/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl;

import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.LazyCanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;

public record StackedLazyFont(LazyCanvasFont[] fonts, CanvasFont.Metadata metadata) implements LazyCanvasFont
{
    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.getGlyphWidth(character, size, offset);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, short color) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.drawGlyph(canvas, character, x, y, size, offset, color);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public boolean containsGlyph(int character) {
        for (LazyCanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isLoaded() {
        for (LazyCanvasFont x : this.fonts) {
            if (x.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void requestLoad() {
        for (LazyCanvasFont x : this.fonts) {
            x.requestLoad();
        }
    }
}

