/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl;

import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.LazyFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.RawBitmapFontSerializer;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.UniHexFontReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MojangUnifontFont
extends LazyFont {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Map Canvas API | Mojang Unifont Loader");
    private final String cachedFile;
    private final String downloadUrl;
    private CompletableFuture<BitmapFont> future;

    public MojangUnifontFont(CanvasFont.Metadata metadata, String cachedFile, String downloadUrl) {
        super(metadata);
        this.cachedFile = cachedFile;
        this.downloadUrl = downloadUrl;
    }

    @Override
    public void requestLoad() {
        if (this.future != null && this.future.isDone()) {
            try {
                this.font = this.future.get();
            }
            catch (Throwable e) {
                this.font = BitmapFont.EMPTY;
                LOGGER.error("Failed to get the font even whe it's done?", e);
            }
            this.future = null;
            return;
        }
        if (this.isLoaded() || this.future != null) {
            return;
        }
        Path path = FabricLoader.getInstance().getGameDir().resolve(".cache/mapcanvas/" + this.cachedFile + ".mcaf");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                this.font = RawBitmapFontSerializer.read(Files.newInputStream(path, new OpenOption[0]));
                return;
            }
            catch (Throwable throwable) {
                try {
                    LOGGER.error("Failed to load Map Canvas Font from {}, redownloading...", (Object)path, (Object)throwable);
                    Files.deleteIfExists(path);
                }
                catch (Throwable error) {
                    LOGGER.error("Failed to remove the {} file! Using fallback font.", (Object)path, (Object)error);
                    this.font = BitmapFont.EMPTY;
                    return;
                }
            }
        }
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).followRedirects(HttpClient.Redirect.ALWAYS).build();
            this.future = ((CompletableFuture)client.sendAsync(HttpRequest.newBuilder(URI.create(this.downloadUrl)).GET().build(), HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(res -> {
                ZipInputStream zip = new ZipInputStream((InputStream)res.body());
                try {
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().endsWith(".hex")) {
                            BitmapFont font = UniHexFontReader.build(zip, this.getMetadata());
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                            try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
                                RawBitmapFontSerializer.write(font, stream);
                            }
                            return font;
                        }
                        entry = zip.getNextEntry();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Failed to download or parse {}! Using fallback font.", (Object)this.downloadUrl, (Object)e);
                    return BitmapFont.EMPTY;
                }
                LOGGER.error("Couldn't find required files in {}!", (Object)this.downloadUrl);
                return BitmapFont.EMPTY;
            })).exceptionally(x -> {
                LOGGER.error("Failed to download {}! Using fallback font.", (Object)this.downloadUrl, x);
                return BitmapFont.EMPTY;
            });
        }
        catch (Throwable e) {
            this.future = null;
            LOGGER.error("Failed to download {}! Using fallback font.", (Object)this.downloadUrl, (Object)e);
            this.font = BitmapFont.EMPTY;
        }
    }

    @Override
    protected void waitUntilLoaded() {
        if (this.isLoaded()) {
            if (this.future != null) {
                try {
                    this.font = this.future.get();
                }
                catch (Throwable e) {
                    this.font = BitmapFont.EMPTY;
                    LOGGER.error("Failed to get the font even whe it's done?", e);
                }
                this.future = null;
            }
            return;
        }
        this.requestLoad();
        try {
            while (!this.isLoaded()) {
                Thread.sleep(1L);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.future != null && this.future.isDone()) {
            try {
                this.font = this.future.get();
            }
            catch (Throwable e) {
                this.font = BitmapFont.EMPTY;
                LOGGER.error("Failed to get the font even whe it's done?", e);
            }
        }
        this.future = null;
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() || this.future != null && this.future.isDone();
    }
}

