/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl;

import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_3532;

public final class BitmapFont
implements CanvasFont {
    public static final BitmapFont EMPTY = new BitmapFont(Glyph.INVALID, CanvasFont.Metadata.empty());
    public final Int2ObjectMap<Glyph> characters = new Int2ObjectOpenHashMap();
    public final Glyph defaultGlyph;
    private final CanvasFont.Metadata metadata;

    public BitmapFont(Glyph defaultGlyph, CanvasFont.Metadata metadata) {
        this.defaultGlyph = defaultGlyph;
        this.metadata = metadata;
    }

    public BitmapFont(Glyph defaultGlyph, Int2ObjectMap<Glyph> characters, CanvasFont.Metadata metadata) {
        this.defaultGlyph = defaultGlyph;
        for (Int2ObjectMap.Entry entry : characters.int2ObjectEntrySet()) {
            this.characters.put(entry.getIntKey(), (Object)((Glyph)entry.getValue()));
        }
        this.metadata = metadata;
    }

    public BitmapFont(Glyph defaultGlyph, Int2ObjectMap<Glyph> characters) {
        this(defaultGlyph, characters, CanvasFont.Metadata.empty());
    }

    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        Glyph glyph = (Glyph)this.characters.getOrDefault(character, (Object)this.defaultGlyph);
        if (glyph.logicalHeight() == 0 || glyph.height() == 0) {
            return (int)((double)glyph.fontWidth() * (size / 8.0));
        }
        double textureScale = (double)glyph.height() / (double)glyph.logicalHeight();
        double baseScale = size / textureScale / 8.0;
        return (int)((double)(glyph.fontWidth() + offset) * baseScale);
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, short color) {
        Glyph glyph = (Glyph)this.characters.getOrDefault(character, (Object)this.defaultGlyph);
        if (glyph.logicalHeight() == 0 || glyph.height() == 0) {
            return (int)((double)glyph.fontWidth() * (size / 8.0));
        }
        double textureScale = (double)glyph.height() / (double)glyph.logicalHeight();
        double baseScale = size / textureScale / 8.0;
        for (int fX = 0; fX < glyph.width(); ++fX) {
            for (int fY = 0; fY < glyph.height(); ++fY) {
                if (!glyph.texture()[fX + fY * glyph.width()]) continue;
                int lX = 0;
                while ((double)lX < baseScale) {
                    int lY = 0;
                    while ((double)lY < baseScale) {
                        canvas.setRaw(x + class_3532.method_15357((double)((double)fX * baseScale)) + lX, y + class_3532.method_15357((double)(((double)fY + (double)(7 - glyph.ascend()) * textureScale) * baseScale)) + lY, color);
                        ++lY;
                    }
                    ++lX;
                }
            }
        }
        return (int)((double)(glyph.fontWidth() + offset) * baseScale);
    }

    @Override
    public boolean containsGlyph(int character) {
        return this.characters.containsKey(character);
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }

    public record Glyph(int width, int height, int ascend, int fontWidth, int logicalHeight, boolean[] texture) {
        public static final Glyph INVALID;
        public static final Glyph EMPTY;

        static {
            EMPTY = new Glyph(0, 0, 0, 0, 0, new boolean[0]);
            boolean[] array = new boolean[40];
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 8; ++y) {
                    if (x != 0 && y != 0 && x != 4 && y != 7) continue;
                    array[x + y * 5] = true;
                }
            }
            INVALID = new Glyph(5, 8, 7, 5, 8, array);
        }
    }
}

