/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font;

import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.AwtFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.StackedFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.RawBitmapFontSerializer;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.UniHexFontReader;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.VanillaFontReader;
import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class FontUtils {
    private FontUtils() {
    }

    public static CanvasFont merge(CanvasFont ... fonts) {
        return new StackedFont(fonts);
    }

    public static CanvasFont merge(CanvasFont.Metadata metadata, CanvasFont ... fonts) {
        return new StackedFont(fonts, metadata);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, identifier);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, CanvasFont.Metadata metadata, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, metadata, identifier);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, CanvasFont.Metadata metadata, Function<String, @Nullable InputStream> fileGetter) {
        return VanillaFontReader.build(fileGetter, metadata, identifier);
    }

    public static CanvasFont fromUniHexFormat(InputStream fontFile, CanvasFont.Metadata metadata) {
        try {
            return UniHexFontReader.build(fontFile, metadata);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return BitmapFont.EMPTY;
        }
    }

    public static CanvasFont fromMapCanvasFontFormat(InputStream stream) {
        BitmapFont font = RawBitmapFontSerializer.read(stream);
        return font != null ? font : BitmapFont.EMPTY;
    }

    public static CanvasFont fromAwtFont(Font font) {
        return new AwtFont(font, CanvasFont.Metadata.create(font.getName(), List.of(), "A font"));
    }

    public static CanvasFont fromAwtFont(Font font, CanvasFont.Metadata metadata) {
        return new AwtFont(font, metadata);
    }

    public static boolean toMapCanvasFontFormat(CanvasFont font, OutputStream stream) {
        if (font instanceof BitmapFont) {
            BitmapFont bitmapFont = (BitmapFont)font;
            return RawBitmapFontSerializer.write(bitmapFont, stream);
        }
        return false;
    }
}

