/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox.font;

import dev.enjarai.minitardis.component.screen.canvas.patbox.font.CanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.FontRegistry;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.FontUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.LazyCanvasFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.BitmapFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.MojangUnifontFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.StackedLazyFont;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.impl.serialization.RawBitmapFontSerializer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public final class DefaultFonts {
    public static final FontRegistry REGISTRY = new FontRegistry();
    public static final CanvasFont VANILLA;
    public static final CanvasFont ALT;
    public static final CanvasFont ILLAGER_ALT;
    public static final CanvasFont UNSANDED;
    public static final CanvasFont UNSANDED_BASE;
    public static final LazyCanvasFont UNIFONT;
    public static final LazyCanvasFont UNIFONT_JP;

    private DefaultFonts() {
    }

    private static CanvasFont read(Path path) {
        BitmapFont font;
        try {
            font = RawBitmapFontSerializer.read(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (Exception e) {
            font = BitmapFont.EMPTY;
            e.printStackTrace();
        }
        return font != null ? font : BitmapFont.EMPTY;
    }

    static {
        Path path = ((ModContainer)FabricLoader.getInstance().getModContainer("mini_tardis").get()).getPath("fonts");
        VANILLA = REGISTRY.register(class_2960.method_60654((String)"minecraft:default"), DefaultFonts.read(path.resolve("vanilla.mcaf")));
        ALT = REGISTRY.register(class_2960.method_60654((String)"minecraft:alt"), DefaultFonts.read(path.resolve("alt.mcaf")));
        ILLAGER_ALT = REGISTRY.register(class_2960.method_60654((String)"minecraft:illageralt"), DefaultFonts.read(path.resolve("illageralt.mcaf")));
        UNSANDED_BASE = REGISTRY.register(class_2960.method_60654((String)"unsanded:base"), DefaultFonts.read(path.resolve("unsanded.mcaf")));
        UNSANDED = REGISTRY.register(class_2960.method_60654((String)"unsanded:full"), FontUtils.merge(UNSANDED_BASE, VANILLA));
        UNIFONT = REGISTRY.register(class_2960.method_60654((String)"unifont:default"), new MojangUnifontFont(CanvasFont.Metadata.create("Unifont", List.of("Roman Czyborra", "Paul Hardy"), "https://scripts.sil.org/OFL"), "unifont_all_no_pua-15.1.05", "https://resources.download.minecraft.net/66/666999116c467f10622db1527a06ddc0a6efad2a"));
        CanvasFont.Metadata jp = CanvasFont.Metadata.create("Unifont JP", List.of("Roman Czyborra", "Paul Hardy"), "https://scripts.sil.org/OFL");
        UNIFONT_JP = REGISTRY.register(class_2960.method_60654((String)"unifont:japanese"), new StackedLazyFont(new LazyCanvasFont[]{new MojangUnifontFont(jp, "unifont_jp_patch-15.1.05", "https://resources.download.minecraft.net/66/666999116c467f10622db1527a06ddc0a6efad2a"), UNIFONT}, jp));
        REGISTRY.register(class_2960.method_60654((String)"minecraft:uniform"), UNIFONT);
    }
}

