/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox;

import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasImage;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import java.awt.image.BufferedImage;

public interface DrawableCanvas {
    public short getRaw(int var1, int var2);

    public void setRaw(int var1, int var2, short var3);

    default public void fillRaw(short color) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.setRaw(x, y, color);
            }
        }
    }

    public int getHeight();

    public int getWidth();

    default public CanvasImage copy() {
        int width = this.getWidth();
        int height = this.getHeight();
        CanvasImage image = new CanvasImage(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRaw(x, y, this.getRaw(x, y));
            }
        }
        return image;
    }

    default public CanvasImage copy(int x, int y, int width, int height) {
        int newWidth = Math.min(this.getWidth() - x, width);
        int newHeight = Math.min(this.getHeight() - y, height);
        CanvasImage image = new CanvasImage(newWidth, newHeight);
        for (int lx = 0; lx < newWidth; ++lx) {
            for (int ly = 0; ly < newHeight; ++ly) {
                image.setRaw(lx, ly, this.getRaw(x + lx, y + ly));
            }
        }
        return image;
    }

    default public BufferedImage toImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        int width = this.getWidth();
        int height = this.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                short color = this.getRaw(x, y);
                image.setRGB(x, y, CanvasUtils.ARGBFromLimitedColor(color) | 0xFF000000);
            }
        }
        return image;
    }

    default public void fillRaw(int x1, int y1, int x2, int y2, short color) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                this.setRaw(x, y, color);
            }
        }
    }

    default public void draw(int x, int y, DrawableCanvas source) {
        int width = source.getWidth();
        int height = source.getHeight();
        for (int lx = 0; lx < width; ++lx) {
            for (int ly = 0; ly < height; ++ly) {
                short color = source.getRaw(lx, ly);
                if (color == 0) continue;
                this.setRaw(lx + x, ly + y, color);
            }
        }
    }

    default public void draw(int x, int y, int width, int height, DrawableCanvas source) {
        int baseWidth = source.getWidth();
        int baseHeight = source.getHeight();
        double deltaX = (double)baseWidth / (double)width;
        double deltaY = (double)baseHeight / (double)height;
        for (int lx = 0; lx < width; ++lx) {
            for (int ly = 0; ly < height; ++ly) {
                short color = source.getRaw((int)((double)lx * deltaX), (int)((double)ly * deltaY));
                if (color == 0) continue;
                this.setRaw(lx + x, ly + y, color);
            }
        }
    }

    default public void bresenhamLine(int x0, int y0, int x1, int y1, short color) {
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            this.setRaw(x0, y0, color);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }
}

