/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.canvas.patbox;

import dev.enjarai.minitardis.ImGoingToStabBasique;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public final class CanvasImage
implements DrawableCanvas {
    public static final StructEndec<CanvasImage> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("width", i -> i.width), (StructField)Endec.INT.fieldOf("height", i -> i.height), (StructField)ImGoingToStabBasique.DEEZ.fieldOf("data", i -> i.data), CanvasImage::new);
    private final int width;
    private final int height;
    private final short[] data;

    public CanvasImage(int width, int height) {
        this(width, height, new short[width * height]);
    }

    private CanvasImage(int width, int height, short[] data) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public static CanvasImage from(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        CanvasImage canvas = new CanvasImage(image.getWidth(), image.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = image.getRGB(x, y);
                canvas.setRaw(x, y, CanvasUtils.toLimitedColor(color));
            }
        }
        return canvas;
    }

    @Override
    public short getRaw(int x, int y) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return 0;
        }
        return this.data[x + y * this.width];
    }

    @Override
    public void setRaw(int x, int y, short color) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return;
        }
        this.data[x + y * this.width] = color;
    }

    @Override
    public void fillRaw(short color) {
        Arrays.fill(this.data, color);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CanvasImage)) {
            return false;
        }
        CanvasImage that = (CanvasImage)o;
        return this.width == that.width && this.height == that.height && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

