/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.GpsApp;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.SmallButtonElement;
import dev.enjarai.minitardis.component.screen.element.WaypointListElement;
import dev.enjarai.minitardis.data.ModDataStuff;
import dev.enjarai.minitardis.data.RandomAppLootFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5819;

public class WaypointsApp
implements ScreenApp {
    public static final Codec<WaypointsApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, Object::toString), TardisLocation.CODEC).optionalFieldOf("waypoints", Map.of()).forGetter(app -> app.waypoints)).apply((Applicative)instance, WaypointsApp::new));
    private final Map<Integer, TardisLocation> waypoints;

    private WaypointsApp(Map<Integer, TardisLocation> waypoints) {
        this.waypoints = new HashMap<Integer, TardisLocation>(waypoints);
    }

    public WaypointsApp() {
        this.waypoints = new HashMap<Integer, TardisLocation>();
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(controls){
            final WaypointListElement waypointList;
            final SmallButtonElement storeLocation;
            final SmallButtonElement loadLocation;
            final SmallButtonElement deleteLocation;
            {
                this.waypointList = this.addElement(new WaypointListElement(4, 45, 124, 50, WaypointsApp.this.waypoints));
                this.storeLocation = this.addElement(new SmallButtonElement(2, 2, "Save", controls1 -> controls1.getTardis().getDestination().ifPresent(location -> {
                    if (this.waypointList.selected != null) {
                        this.waypointList.selected.setWaypointValue((TardisLocation)location);
                    }
                })));
                this.loadLocation = this.addElement(new SmallButtonElement(2, 2, "Load", controls1 -> {
                    if (this.waypointList.selected != null && this.waypointList.selected.getWaypointValue() != null) {
                        controls1.getTardis().setDestination(this.waypointList.selected.getWaypointValue(), false);
                    }
                }));
                this.deleteLocation = this.addElement(new SmallButtonElement(30, 2, "Clear", controls1 -> {
                    if (this.waypointList.selected != null) {
                        this.waypointList.selected.clearWaypointValue();
                    }
                }));
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                this.storeLocation.visible = false;
                this.loadLocation.visible = false;
                this.deleteLocation.visible = false;
                if (this.waypointList.selected == null) {
                    DefaultFonts.VANILLA.drawText(canvas, "Select Waypoint below", 6, 31, 8.0, CanvasColors.LIGHT_GRAY);
                } else {
                    TardisLocation location = this.waypointList.selected.getWaypointValue();
                    if (location == null) {
                        this.storeLocation.visible = true;
                        DefaultFonts.VANILLA.drawText(canvas, "Empty", 6, 31, 8.0, CanvasColors.LIGHT_GRAY);
                    } else {
                        this.loadLocation.visible = true;
                        this.deleteLocation.visible = true;
                        if (location.equals(this.controls.getTardis().getDestination().orElse(null))) {
                            canvas.draw(2, 18, TardisCanvasUtils.getSprite("history_current_outline"));
                        }
                        GpsApp.drawLocation(Optional.of(location), canvas, 6, 22);
                    }
                }
                super.draw(blockEntity, canvas);
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("waypoints_background"));
            }
        };
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/waypoints"));
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"mini_tardis.app.mini_tardis.waypoints.tooltip", (Object[])new Object[]{this.waypoints.size()})).method_27696(class_2583.field_24360.method_10977(class_124.field_1063)));
    }

    @Override
    public void applyLootModifications(class_47 context, RandomAppLootFunction lootFunction) {
        class_243 vec3d = (class_243)context.method_296(class_181.field_24424);
        if (vec3d != null) {
            class_3218 serverWorld = context.method_299();
            class_5819 random = context.method_294();
            for (int i = 0; i < random.method_39332(1, 8); ++i) {
                class_2338 blockPos = serverWorld.method_8487(ModDataStuff.WAYPOINT_APP_RANDOMLY_FOUND_STRUCTURES, class_2338.method_49638((class_2374)vec3d), 50, true);
                if (blockPos == null) continue;
                this.waypoints.put(random.method_43048(90), new TardisLocation((class_5321<class_1937>)serverWorld.method_27983(), blockPos.method_33096(64), class_2350.method_10139((int)random.method_43054())));
            }
        }
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.WAYPOINTS;
    }
}

