/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.InterdictState;
import dev.enjarai.minitardis.component.flight.RefuelingState;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasImage;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import java.util.Arrays;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5819;
import net.minecraft.class_6575;

public class StatusApp
implements ScreenApp {
    public static final Codec<StatusApp> CODEC = Codec.unit(StatusApp::new);
    private final class_5819 etaRandom = new class_6575(0L);

    @Override
    public AppView getView(final TardisControl controls) {
        return new AppView(){
            final int[] lastOffsets = new int[8];

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                Tardis tardis = controls.getTardis();
                long time = tardis.getInteriorWorld().method_8510();
                DefaultFonts.VANILLA.drawText(canvas, tardis.getState().getName().getString(), 4, 6, 8.0, CanvasColors.WHITE);
                tardis.getState(DriftingState.class).ifPresent(state -> {
                    for (int i = 0; i < state.phaseCount; ++i) {
                        CanvasImage icon = state.phasesComplete > i ? TardisCanvasUtils.getSprite("drifting_phase_complete") : (state.phasesComplete >= i && state.phaseTicks >= state.phaseLength ? TardisCanvasUtils.getSprite("drifting_phase_available") : TardisCanvasUtils.getSprite("drifting_phase"));
                        canvas.draw(8 + i * 8, 24, icon);
                    }
                });
                tardis.getState(FlyingState.class).ifPresent(state -> {
                    for (int i = 0; i < state.offsets.length; ++i) {
                        int offset = state.offsets[i];
                        CanvasImage icon = offset > 0 ? TardisCanvasUtils.getSprite("offset_right") : (offset < 0 ? TardisCanvasUtils.getSprite("offset_left") : TardisCanvasUtils.getSprite("offset_centered"));
                        canvas.draw(8 + i / 2 * 10, 24 + i % 2 * 6, icon);
                    }
                    canvas.draw(7 + state.scaleState * 10, 23, TardisCanvasUtils.getSprite("offset_set_selected"));
                    DefaultFonts.VANILLA.drawText(canvas, "ER: " + state.getDistance(), 8, 41, 8.0, CanvasColors.WHITE);
                });
                tardis.getState(RefuelingState.class).ifPresent(state -> {
                    StatusApp.this.etaRandom.method_43052(time / 40L);
                    int seconds = 1000 - tardis.getFuel() * StatusApp.this.etaRandom.method_39332(99, 101) / 100;
                    int minutes = seconds / 60;
                    DefaultFonts.VANILLA.drawText(canvas, "Time to full:", 8, 24, 8.0, CanvasColors.LIGHT_GRAY);
                    DefaultFonts.VANILLA.drawText(canvas, "%d:%02d".formatted(minutes, seconds %= 60), 8, 35, 8.0, CanvasColors.WHITE);
                });
                class_5819 random = blockEntity.drawRandom;
                FlightState state2 = tardis.getState();
                boolean isSolid = state2.isSolid(tardis);
                int stutterOffsetStability = isSolid ? 0 : random.method_39332(-1, 1);
                int waveOffsetStability = 0;
                if (!isSolid) {
                    double wave1 = (Math.sin((double)time / 30.0) - 1.0) * 2.5;
                    double wave2 = (Math.sin((double)time / 13.0 + 0.5) - 1.0) * 1.5;
                    double wave3 = (Math.sin((double)time / 8.0 + 0.3) - 1.0) * 1.0;
                    waveOffsetStability = (int)(wave1 + wave2 + wave3);
                }
                StatusApp.this.drawVerticalBar(canvas, tardis.getStability() * 480 / 10000 + stutterOffsetStability + waveOffsetStability, 96, 16, TardisCanvasUtils.getSprite("vertical_bar_orange"), "STB");
                int stutterOffsetFuel = isSolid || state2 instanceof RefuelingState && tardis.getFuel() < 1000 ? 0 : random.method_39332(-1, 1);
                StatusApp.this.drawVerticalBar(canvas, tardis.getFuel() * 480 / 10000 + stutterOffsetFuel, 72, 16, TardisCanvasUtils.getSprite("vertical_bar_blue"), "ART");
                tardis.getState(InterdictState.class).ifPresentOrElse(interdictState -> {
                    canvas.draw(0, 16, TardisCanvasUtils.getSprite("intercept_radar"));
                    int targetX = interdictState.getTargetX();
                    int targetY = interdictState.getTargetY();
                    int currentX = interdictState.getOffsetX();
                    int currentY = interdictState.getOffsetY();
                    canvas.draw(35 + targetX * 6, 39 + targetY * 6, TardisCanvasUtils.getSprite("intercept_target"));
                    canvas.draw(35 + currentX * 6, 39 + currentY * 6, TardisCanvasUtils.getSprite("intercept_current"));
                    int phase = interdictState.getPhasesComplete();
                    int otherPhase = interdictState.getLinkedState(tardis).map(InterdictState::getPhasesComplete).orElse(0);
                    for (int i = 0; i < 6; ++i) {
                        canvas.draw(8 + i * 8, 68, TardisCanvasUtils.getSprite(i < phase ? "intercept_phase_complete" : "intercept_phase"));
                        canvas.draw(8 + i * 8, 76, TardisCanvasUtils.getSprite(i < otherPhase ? "intercept_phase_other_complete" : "intercept_phase_other"));
                    }
                }, () -> {
                    boolean conduitsUnlocked = controls.areEnergyConduitsUnlocked();
                    canvas.draw(24, 48, conduitsUnlocked ? TardisCanvasUtils.getSprite("energy_conduits_active") : TardisCanvasUtils.getSprite("energy_conduits_inactive"));
                    DefaultFonts.VANILLA.drawText(canvas, "CND", 31, 80, 8.0, CanvasColors.WHITE);
                    boolean destinationLocked = controls.isDestinationLocked();
                    canvas.draw(0, 48, destinationLocked ? TardisCanvasUtils.getSprite("lock_icon_locked") : TardisCanvasUtils.getSprite("lock_icon_unlocked"));
                    DefaultFonts.VANILLA.drawText(canvas, "LCK", 7, 80, 8.0, CanvasColors.WHITE);
                });
            }

            @Override
            public void screenTick(ScreenBlockEntity blockEntity) {
                controls.getTardis().getState(FlyingState.class).ifPresentOrElse(state -> {
                    for (int i = 0; i < this.lastOffsets.length; ++i) {
                        int current = state.offsets[i];
                        int last = this.lastOffsets[i];
                        if (current == last) continue;
                        this.lastOffsets[i] = current;
                        if (current != 0) continue;
                        blockEntity.playSound((class_3414)class_3417.field_14725.comp_349(), 1.0f, 1.0f);
                    }
                }, () -> Arrays.fill(this.lastOffsets, 0));
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("status_background"));
            }

            @Override
            public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
                return false;
            }
        };
    }

    private void drawVerticalBar(DrawableCanvas canvas, int value, int x, int y, CanvasImage barType, String label) {
        canvas.draw(x, y, TardisCanvasUtils.getSprite("vertical_bar_empty"));
        for (int ly = 48 - value; ly < 48; ++ly) {
            for (int lx = 0; lx < 16; ++lx) {
                short color = barType.getRaw(8 + lx, 8 + ly);
                if (color == 0) continue;
                canvas.setRaw(8 + lx + x, 8 + ly + y, color);
            }
        }
        int labelWidth = DefaultFonts.VANILLA.getTextWidth(label, 8.0);
        DefaultFonts.VANILLA.drawText(canvas, label, x + 15 - labelWidth / 2, y + 64, 8.0, CanvasColors.WHITE);
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/status"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.STATUS;
    }
}

