/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.BadAppleApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.SnakeApp;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;

public class SnakeOnBadAppleApp
extends SnakeApp {
    public static final Codec<SnakeOnBadAppleApp> CODEC = Codec.unit(SnakeOnBadAppleApp::new);

    @Override
    public AppView getView(TardisControl controls) {
        return new BadSnakeAppView(controls);
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/bad_snake"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return null;
    }

    public static class BadSnakeAppView
    extends SnakeApp.SnakeAppView {
        public BadAppleApp.BadAppleView badAppleAppView = new BadAppleApp.BadAppleView(){

            @Override
            public void endAnimation(ScreenBlockEntity blockEntity) {
                this.reset(blockEntity);
            }
        };
        public boolean animationStarted = false;

        public BadSnakeAppView(TardisControl tardisControl) {
            super(tardisControl);
        }

        @Override
        public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
            if (this.animationStarted) {
                this.badAppleAppView.draw(blockEntity, canvas);
            }
            canvas.draw(0, 0, TardisCanvasUtils.getSprite("snake_overlay"));
            super.draw(blockEntity, canvas);
        }

        @Override
        public void ateApple(ScreenBlockEntity blockEntity) {
            if (!this.animationStarted) {
                this.badAppleAppView.screenOpen(blockEntity);
            }
            this.animationStarted = true;
            super.ateApple(blockEntity);
        }

        public void reset(ScreenBlockEntity blockEntity) {
            this.badAppleAppView.screenClose(blockEntity);
            this.badAppleAppView.screenOpen(blockEntity);
        }

        @Override
        public void screenClose(ScreenBlockEntity blockEntity) {
            this.badAppleAppView.screenClose(blockEntity);
        }
    }
}

