/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.AppleElement;
import dev.enjarai.minitardis.component.screen.element.SnakeElement;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class SnakeApp
implements ScreenApp {
    public static final Codec<SnakeApp> CODEC = Codec.unit(SnakeApp::new);

    @Override
    public AppView getView(TardisControl controls) {
        return new SnakeAppView(controls);
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/snake"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.SNAKE;
    }

    public static class SnakeAppView
    implements AppView {
        public final class_5819 deterministicRandom = new class_6575((long)"LouisAndEnjaraiAreCool".hashCode());
        public final SnakeElement snake = new SnakeElement(this);
        public final AppleElement apple = new AppleElement(this);
        private final TardisControl tardisControl;
        private boolean died = false;
        private int ticksDead = 0;
        private boolean isPaused = false;
        protected int pausedTicks = 0;
        private boolean won;
        private int wonTicks = 0;

        public SnakeAppView(TardisControl tardisControl) {
            this.tardisControl = tardisControl;
        }

        @Override
        public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
            if (this.pausedTicks % 16 > 7) {
                return;
            }
            this.snake.draw(this.tardisControl, blockEntity, canvas);
            this.apple.draw(this.tardisControl, blockEntity, canvas);
            String string = this.isPaused ? "Paused" : "";
            string = this.died ? "You died" : string;
            string = this.won ? "You won!" : string;
            DefaultFonts.VANILLA.drawText(canvas, (String)(string.isEmpty() ? "Score: " + this.snake.tailLength : string), 5, 6, 8.0, CanvasColors.LIGHT_GRAY);
        }

        @Override
        public void screenTick(ScreenBlockEntity blockEntity) {
            if (this.won) {
                ++this.wonTicks;
                if (this.wonTicks > 10) {
                    blockEntity.closeApp();
                }
                return;
            }
            if (this.died) {
                ++this.ticksDead;
                if (this.ticksDead > 10) {
                    blockEntity.closeApp();
                }
                return;
            }
            if (this.isPaused) {
                ++this.pausedTicks;
                return;
            }
            this.snake.tick(this.tardisControl, blockEntity);
            this.apple.tick(this.tardisControl, blockEntity);
        }

        @Override
        public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
            if (this.won) {
                return false;
            }
            if (this.died) {
                return false;
            }
            if (type == class_5536.field_27013) {
                this.isPaused = !this.isPaused;
                this.pausedTicks = 0;
                return false;
            }
            Vector2i clickPos = new Vector2i(x, y);
            Vector2i snakePos = new Vector2i(this.snake.x, this.snake.y);
            Vector2i resultVector = clickPos.sub((Vector2ic)snakePos);
            this.snake.snakeMove = this.snake.snakeMove.getSnakeMove(resultVector);
            blockEntity.method_10997().method_8396(null, blockEntity.method_11016(), ModSounds.SNAKE_MOVE, class_3419.field_15256, 0.3f, 1.0f);
            return false;
        }

        @Override
        public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
            canvas.draw(0, 0, TardisCanvasUtils.getSprite("dimensions_background"));
        }

        public void snakeDied(ScreenBlockEntity blockEntity) {
            blockEntity.method_10997().method_8396(null, blockEntity.method_11016(), ModSounds.DIE_SNAKE, class_3419.field_15256, 1.0f, 1.0f);
            this.died = true;
        }

        public void won(ScreenBlockEntity blockEntity) {
            blockEntity.method_10997().method_8396(null, blockEntity.method_11016(), class_3417.field_14709, class_3419.field_15256, 0.3f, 1.0f);
            this.won = true;
        }

        public void ateApple(ScreenBlockEntity blockEntity) {
            this.snake.ateApple();
            blockEntity.method_10997().method_8396(null, blockEntity.method_11016(), ModSounds.EAT_APPLE, class_3419.field_15256, 0.3f, 1.0f);
        }
    }
}

