/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.Rotate90ClockwiseView;
import dev.enjarai.minitardis.component.screen.element.SmallButtonElement;
import net.minecraft.class_3620;
import net.minecraft.class_5253;

public class ScannerApp
implements ScreenApp {
    public static final Codec<ScannerApp> CODEC = Codec.unit(ScannerApp::new);

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(this, controls){
            {
                this.addElement(new SmallButtonElement(98, 16, "XAxis", controls -> controls.getTardis().getDestinationScanner().useXAxis()));
                this.addElement(new SmallButtonElement(98, 30, "ZAxis", controls -> controls.getTardis().getDestinationScanner().useZAxis()));
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                for (int x = 0; x < 96; ++x) {
                    for (int y = 0; y < 96; ++y) {
                        byte value = this.controls.getTardis().getDestinationScanner().getFor(x, y);
                        int color = class_3620.method_38479((int)value).method_15820(class_3620.class_6594.field_34760);
                        canvas.setRaw(x, -y - 1 + 96, CanvasUtils.toLimitedColor(class_5253.class_8045.method_60675((int)color)));
                    }
                }
                canvas.setRaw(47, 48, CanvasColors.ORANGE);
                canvas.setRaw(47, 47, CanvasColors.ORANGE);
                boolean isZ = this.controls.getTardis().getDestinationScanner().isZAxis();
                canvas.draw(96, 64, isZ ? TardisCanvasUtils.getSprite("coord_widget_z") : TardisCanvasUtils.getSprite("coord_widget_x"));
                this.controls.getTardis().getDestination().ifPresent(destination -> {
                    int rotation = destination.facing().method_10161();
                    if (isZ) {
                        rotation = (rotation + 3) % 4;
                    }
                    DrawableCanvas view = TardisCanvasUtils.getSprite("destination_facing_widget");
                    for (int i = 0; i < rotation; ++i) {
                        view = new Rotate90ClockwiseView(view);
                    }
                    canvas.draw(96, 64, view);
                });
                super.draw(blockEntity, canvas);
            }

            @Override
            public void screenTick(ScreenBlockEntity blockEntity) {
                this.controls.getTardis().getDestinationScanner().shouldScanNextTick();
            }
        };
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/scanner"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.SCANNER;
    }
}

