/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.AppSelectorElement;
import dev.enjarai.minitardis.component.screen.element.InstallableAppElement;
import dev.enjarai.minitardis.item.FloppyItem;
import java.util.List;
import net.minecraft.class_1799;

public class PackageManagerApp
implements ScreenApp {
    public static final Codec<PackageManagerApp> CODEC = Codec.unit(PackageManagerApp::new);

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(this, controls){
            private final AppSelectorElement leftElement = new AppSelectorElement(2, 18);
            private final AppSelectorElement rightElement = new AppSelectorElement(65, 18);
            private boolean floppyInserted;
            {
                this.addElement(this.leftElement);
                this.addElement(this.rightElement);
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                InstallableAppElement selected;
                InstallableAppElement installableAppElement = selected = this.leftElement.selected == null ? this.rightElement.selected : this.leftElement.selected;
                if (selected != null) {
                    DefaultFonts.VANILLA.drawText(canvas, selected.app.getName().getString(), 4, 6, 8.0, CanvasColors.WHITE);
                }
                if (!this.floppyInserted) {
                    TardisCanvasUtils.drawCenteredText(canvas, "Insert", 28, 30, CanvasColors.WHITE);
                    TardisCanvasUtils.drawCenteredText(canvas, "Floppy", 28, 40, CanvasColors.WHITE);
                } else if (this.leftElement.getElements().isEmpty()) {
                    TardisCanvasUtils.drawCenteredText(canvas, "Empty", 28, 30, CanvasColors.LIGHT_GRAY);
                }
                super.draw(blockEntity, canvas);
            }

            @Override
            public void screenOpen(ScreenBlockEntity blockEntity) {
                this.updateInstalledApps();
            }

            @Override
            public void screenTick(ScreenBlockEntity blockEntity) {
                boolean newFloppyState;
                class_1799 floppyStack = blockEntity.inventory.method_5438(0);
                boolean bl = newFloppyState = !floppyStack.method_7960();
                if (this.floppyInserted != newFloppyState) {
                    this.updateSourceApps(floppyStack);
                    this.floppyInserted = newFloppyState;
                }
            }

            private void updateSourceApps(class_1799 floppyStack) {
                this.leftElement.clearElements();
                List<ScreenApp> apps = FloppyItem.getApps(floppyStack);
                for (int i = 0; i < apps.size(); ++i) {
                    ScreenApp app = apps.get(i);
                    this.leftElement.addElement(new InstallableAppElement(i % 2 * 26, i / 2 * 26, app, false, this.leftElement, el -> {
                        this.rightElement.selected = null;
                    }, this::installApp));
                }
            }

            private void updateInstalledApps() {
                this.rightElement.clearElements();
                List<ScreenApp> apps = this.controls.getAllApps().stream().filter(ScreenApp::canBeUninstalled).toList();
                for (int i = 0; i < apps.size(); ++i) {
                    ScreenApp app = apps.get(i);
                    this.rightElement.addElement(new InstallableAppElement(i % 2 * 26, i / 2 * 26, app, true, this.rightElement, el -> {
                        this.leftElement.selected = null;
                    }, this::uninstallApp));
                }
            }

            private boolean installApp(ScreenBlockEntity blockEntity, InstallableAppElement element) {
                int i = this.leftElement.getElements().indexOf(element);
                class_1799 floppyStack = blockEntity.inventory.method_5438(0);
                if (this.controls.canInstallApp(element.app) && FloppyItem.removeApp(floppyStack, i)) {
                    this.controls.installApp(element.app);
                    this.updateInstalledApps();
                    this.updateSourceApps(floppyStack);
                    return true;
                }
                return false;
            }

            private boolean uninstallApp(ScreenBlockEntity blockEntity, InstallableAppElement element) {
                if (this.floppyInserted) {
                    class_1799 floppyStack = blockEntity.inventory.method_5438(0);
                    if (this.controls.canUninstallApp(element.app.getType())) {
                        FloppyItem.addApp(floppyStack, element.app);
                        this.controls.uninstallApp(element.app.getType());
                        this.updateInstalledApps();
                        this.updateSourceApps(floppyStack);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("package_manager_background"));
            }
        };
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/package_manager"));
    }

    @Override
    public boolean canBeUninstalled() {
        return false;
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.PACKAGE_MANAGER;
    }
}

