/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasImage;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.SubView;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import java.awt.Color;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_5536;
import org.jetbrains.annotations.Nullable;

public class LookAndFeelApp
implements ScreenApp {
    public static final Codec<LookAndFeelApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT_STREAM.optionalFieldOf("history", (Object)IntStream.empty()).forGetter(app -> IntStream.of(app.history))).apply((Applicative)instance, LookAndFeelApp::new));
    public static final int SV_SIZE = 76;
    public static final int H_WIDTH = 16;
    private final int[] history;

    private LookAndFeelApp(int[] history) {
        this.history = history;
    }

    private LookAndFeelApp(IntStream history) {
        this(Arrays.copyOf(history.toArray(), 6));
    }

    public LookAndFeelApp() {
        this(new int[]{CanvasUtils.ARGBFromLimitedColor(CanvasColors.BACKGROUND), 0, 0, 0, 0, 0});
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new AppView(){
            boolean initialized;
            float h;
            float s;
            float v;
            @Nullable
            DrawableCanvas pickerCanvas;

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                if (!this.initialized) {
                    float[] hsv = LookAndFeelApp.rgbToHsv(CanvasUtils.ARGBFromLimitedColor(blockEntity.backgroundColor));
                    this.h = hsv[0];
                    this.s = hsv[1];
                    this.v = hsv[2];
                    this.initialized = true;
                }
                if (this.pickerCanvas == null) {
                    int[][] pickerPixels = new int[94][76];
                    for (int s = 0; s < 76; ++s) {
                        for (int v = 0; v < 76; ++v) {
                            int rgb;
                            pickerPixels[s][76 - v - 1] = rgb = class_3532.method_60599((float)this.h, (float)((float)s / 76.0f), (float)((float)v / 76.0f), (int)255);
                        }
                    }
                    for (int h = 0; h < 76; ++h) {
                        int rgb = class_3532.method_60599((float)((float)h / 76.0f), (float)1.0f, (float)1.0f, (int)255);
                        for (int i = 0; i < 16; ++i) {
                            pickerPixels[78 + i][h] = rgb;
                        }
                    }
                    CanvasImage pickerCanvas = new CanvasImage(94, 76);
                    for (int x = 0; x < 94; ++x) {
                        for (int y = 0; y < 76; ++y) {
                            if (x >= 76 && x < 78) continue;
                            pickerCanvas.setRaw(x, y, CanvasUtils.toLimitedColor(pickerPixels[x][y]));
                        }
                    }
                    pickerCanvas.draw(78, (int)(-4.0f + this.h * 76.0f), TardisCanvasUtils.getSprite("hue_selector"));
                    this.pickerCanvas = pickerCanvas;
                }
                DefaultFonts.VANILLA.drawText(canvas, "Background Color", 4, 6, 8.0, CanvasColors.WHITE);
                canvas.draw(2, 18, this.pickerCanvas);
                new SubView(canvas, 2, 18, 76, 76).draw(-8 + (int)(this.s * 76.0f), 69 - (int)(this.v * 76.0f), TardisCanvasUtils.getSprite("sv_selector"));
                int historySize = 11;
                int historyOffset = 2;
                for (int i = 0; i < LookAndFeelApp.this.history.length; ++i) {
                    int x = 115;
                    int y = 18 + (historySize + historyOffset) * i;
                    canvas.fillRaw(x, y, x + historySize, y + historySize, CanvasUtils.toLimitedColor(LookAndFeelApp.this.history[i]));
                }
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("look_and_feel_background"));
            }

            @Override
            public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
                if (y >= 18 && y < 94) {
                    if (x >= 2 && x < 78) {
                        this.s = (float)(x - 2) / 76.0f;
                        this.v = (float)(76 - (y - 19)) / 76.0f;
                        blockEntity.backgroundColor = CanvasUtils.toLimitedColor(class_3532.method_60599((float)this.h, (float)this.s, (float)this.v, (int)255));
                        blockEntity.playClickSound(1.0f);
                        return true;
                    }
                    if (x >= 80 && x < 96) {
                        this.h = (float)(y - 18) / 76.0f;
                        this.pickerCanvas = null;
                        blockEntity.backgroundColor = CanvasUtils.toLimitedColor(class_3532.method_60599((float)this.h, (float)this.s, (float)this.v, (int)255));
                        blockEntity.playClickSound(0.9f);
                        return true;
                    }
                    if (x >= 115 && x < 126) {
                        for (int i = 0; i < LookAndFeelApp.this.history.length; ++i) {
                            int cy = 18 + 13 * i;
                            if (y < cy || y >= cy + 11) continue;
                            int color = LookAndFeelApp.this.history[i];
                            float[] hsv = LookAndFeelApp.rgbToHsv(color);
                            this.h = hsv[0];
                            this.s = hsv[1];
                            this.v = hsv[2];
                            this.pickerCanvas = null;
                            blockEntity.backgroundColor = CanvasUtils.toLimitedColor(color);
                            blockEntity.playClickSound(1.1f);
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public void screenClose(ScreenBlockEntity blockEntity) {
                int newColor = CanvasUtils.ARGBFromLimitedColor(CanvasUtils.toLimitedColor(class_3532.method_60599((float)this.h, (float)this.s, (float)this.v, (int)255)));
                if (newColor != LookAndFeelApp.this.history[0]) {
                    for (int i = LookAndFeelApp.this.history.length - 1; i > 0; --i) {
                        LookAndFeelApp.this.history[i] = LookAndFeelApp.this.history[i - 1];
                    }
                    LookAndFeelApp.this.history[0] = newColor;
                }
            }
        };
    }

    private static short floydDither(int[][] pixels, int x, int y, int imageColor) {
        short closestColor = CanvasUtils.toLimitedColor(imageColor);
        int palletedColor = CanvasUtils.ARGBFromLimitedColor(closestColor);
        int errorR = class_5253.class_5254.method_27765((int)imageColor) - class_5253.class_5254.method_27765((int)palletedColor);
        int errorG = class_5253.class_5254.method_27766((int)imageColor) - class_5253.class_5254.method_27766((int)palletedColor);
        int errorB = class_5253.class_5254.method_27767((int)imageColor) - class_5253.class_5254.method_27767((int)palletedColor);
        if (pixels[0].length > y + 1) {
            pixels[x][y + 1] = LookAndFeelApp.applyError(pixels[x][y + 1], errorR, errorG, errorB, 0.4375);
        }
        if (pixels.length > x + 1) {
            if (y > 0) {
                pixels[x + 1][y - 1] = LookAndFeelApp.applyError(pixels[x + 1][y - 1], errorR, errorG, errorB, 0.1875);
            }
            pixels[x + 1][y] = LookAndFeelApp.applyError(pixels[x + 1][y], errorR, errorG, errorB, 0.3125);
            if (pixels[0].length > y + 1) {
                pixels[x + 1][y + 1] = LookAndFeelApp.applyError(pixels[x + 1][y + 1], errorR, errorG, errorB, 0.0625);
            }
        }
        return closestColor;
    }

    private static int applyError(int pixelColor, int errorR, int errorG, int errorB, double quantConst) {
        int pR = class_3532.method_15340((int)(class_5253.class_5254.method_27765((int)pixelColor) + (int)((double)errorR * quantConst)), (int)0, (int)255);
        int pG = class_3532.method_15340((int)(class_5253.class_5254.method_27766((int)pixelColor) + (int)((double)errorG * quantConst)), (int)0, (int)255);
        int pB = class_3532.method_15340((int)(class_5253.class_5254.method_27767((int)pixelColor) + (int)((double)errorB * quantConst)), (int)0, (int)255);
        return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)pixelColor), (int)pR, (int)pG, (int)pB);
    }

    private static float[] rgbToHsv(int rgb) {
        int r = class_5253.class_5254.method_27765((int)rgb);
        int g = class_5253.class_5254.method_27766((int)rgb);
        int b = class_5253.class_5254.method_27767((int)rgb);
        return Color.RGBtoHSB(r, g, b, null);
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/look_and_feel"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.LOOK_AND_FEEL;
    }
}

