/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.FlightWave;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.element.InterdictionSliderElement;
import dev.enjarai.minitardis.component.screen.element.ResizableButtonElement;
import dev.enjarai.minitardis.component.screen.element.ThreeSelectElement;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_5321;
import net.minecraft.class_5819;

public class InterdictorApp
implements ScreenApp {
    public static final Codec<InterdictorApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("selected_wave_part", (Object)0).forGetter(app -> app.selectedWavePart), (App)FlightWave.CODEC.optionalFieldOf("selected_wave", (Object)new FlightWave(0.5, 0.5, 0.5)).forGetter(app -> app.selectedWave)).apply((Applicative)instance, InterdictorApp::new));
    private int selectedWavePart;
    private final FlightWave selectedWave;

    private InterdictorApp(int selectedWavePart, FlightWave selectedWave) {
        this.selectedWavePart = selectedWavePart;
        this.selectedWave = selectedWave;
    }

    public InterdictorApp() {
        this(0, new FlightWave(0.5, 0.5, 0.5));
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(controls){
            private final ThreeSelectElement wavePartElement;
            private final InterdictionSliderElement waveSliderElement;
            private final ResizableButtonElement restartButton;
            {
                this.waveSliderElement = this.addElement(new InterdictionSliderElement(16, 2, InterdictorApp.this.selectedWave.getValue(InterdictorApp.this.selectedWavePart), (controls, state) -> InterdictorApp.this.selectedWave.setValue(InterdictorApp.this.selectedWavePart, (int)state)));
                this.wavePartElement = this.addElement(new ThreeSelectElement(2, 2, InterdictorApp.this.selectedWavePart, (controls, state) -> {
                    InterdictorApp.this.selectedWavePart = state;
                    this.waveSliderElement.state = InterdictorApp.this.selectedWave.getValue((int)state);
                }));
                this.restartButton = this.addElement(new ResizableButtonElement(27, 70, 70, "Lock Target", controls -> {
                    for (Tardis otherTardis : controls.getTardis().getHolder().getInterdictableTardii()) {
                        if (!InterdictorApp.this.selectedWave.equals(otherTardis.getFlightWave())) continue;
                        class_5819 random = controls.getTardis().getRandom();
                        controls.getTardis().setDestination(new TardisLocation((class_5321<class_1937>)otherTardis.getInteriorWorld().method_27983(), otherTardis.getInteriorDoorPosition().method_10069(random.method_39332(-10, 10), random.method_39332(-10, 10), random.method_39332(-10, 10)), controls.getTardis().getDestination().map(TardisLocation::facing).orElse(class_2350.field_11043)), true);
                    }
                }));
                this.restartButton.visible = false;
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                Tardis tardis = this.controls.getTardis();
                long timeyTimey = tardis.getInteriorWorld().method_8510() * 2L;
                if (tardis.getState().canBeInterdicted(tardis)) {
                    this.drawWave(canvas, tardis.getFlightWave(), timeyTimey, (short)-3550);
                }
                boolean lockable = false;
                for (Tardis otherTardis : tardis.getHolder().getInterdictableTardii()) {
                    if (tardis == otherTardis) continue;
                    this.drawWave(canvas, otherTardis.getFlightWave(), timeyTimey, (short)-3197);
                    if (!InterdictorApp.this.selectedWave.equals(otherTardis.getFlightWave())) continue;
                    lockable = true;
                }
                this.restartButton.visible = lockable;
                this.drawWave(canvas, InterdictorApp.this.selectedWave, timeyTimey, (short)-896);
                if (tardis.getDestinationWorld().map(w -> Tardis.isTardis((class_5321<class_1937>)w.method_27983())).orElse(false).booleanValue()) {
                    canvas.draw(0, 0, TardisCanvasUtils.getSprite("interdictor_target_locked"));
                    this.restartButton.pressedFrames = 1;
                }
                super.draw(blockEntity, canvas);
            }

            void drawWave(DrawableCanvas canvas, FlightWave wave, double offset, short color) {
                for (int x = 3; x < 126; ++x) {
                    int y1 = 55 + (int)(Math.sin(((double)x + offset + wave.getOffset() * 35.0 - 1.0) * wave.getPeriod() * 0.5) * 35.0 * wave.getMagnitude());
                    int y2 = 55 + (int)(Math.sin(((double)x + offset + wave.getOffset() * 35.0) * wave.getPeriod() * 0.5) * 35.0 * wave.getMagnitude());
                    canvas.bresenhamLine(x - 1, y1, x, y2, color);
                }
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("interdictor_background"));
            }
        };
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.INTERDICTOR;
    }
}

