/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.HistoryEntry;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.GpsApp;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.AppElement;
import dev.enjarai.minitardis.component.screen.element.SmallButtonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class HistoryApp
implements ScreenApp {
    public static final Codec<HistoryApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HistoryEntry.CODEC.listOf().optionalFieldOf("history", List.of()).forGetter(app -> app.history)).apply((Applicative)instance, HistoryApp::new));
    private static final int ENTRIES_PER_PAGE = 3;
    public final List<HistoryEntry> history;

    private HistoryApp(List<HistoryEntry> history) {
        this.history = new ArrayList<HistoryEntry>(history);
    }

    public HistoryApp() {
        this.history = new ArrayList<HistoryEntry>();
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(controls){
            private int currentPage;
            private final List<SmallButtonElement> shownEntryButtons;
            {
                this.shownEntryButtons = List.of(new SmallButtonElement(98, 28, "Set", this.selectVisibleEntry(0)), new SmallButtonElement(98, 54, "Set", this.selectVisibleEntry(1)), new SmallButtonElement(98, 80, "Set", this.selectVisibleEntry(2)));
                this.addElement(new SmallButtonElement(2, 2, "Prev", controls -> {
                    this.currentPage = Math.max(this.currentPage - 1, 0);
                }));
                this.addElement(new SmallButtonElement(30, 2, "Next", controls -> {
                    this.currentPage = Math.min(this.currentPage + 1, (HistoryApp.this.history.size() - 1) / 3);
                }));
            }

            @Override
            public Iterable<AppElement> children() {
                return Iterables.concat(super.children(), this.shownEntryButtons.subList(0, Math.min(HistoryApp.this.history.size() - this.currentPage * 3, 3)));
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                DefaultFonts.VANILLA.drawText(canvas, this.currentPage + 1 + "/" + ((HistoryApp.this.history.size() - 1) / 3 + 1), 62, 7, 8.0, CanvasColors.WHITE);
                for (int i = this.currentPage * 3; i < Math.min(this.currentPage * 3 + 3, HistoryApp.this.history.size()); ++i) {
                    int relativeIndex = i - this.currentPage * 3;
                    HistoryEntry entry = HistoryApp.this.history.get(i);
                    if (entry.location().equals(this.controls.getTardis().getDestination().orElse(null))) {
                        canvas.draw(2, 18 + 26 * relativeIndex, TardisCanvasUtils.getSprite("history_current_outline"));
                    }
                    String numText = i + 1 + ".";
                    int numWidth = DefaultFonts.VANILLA.getTextWidth(numText, 8.0);
                    DefaultFonts.VANILLA.drawText(canvas, numText, 4, 20 + 26 * relativeIndex, 8.0, CanvasColors.WHITE);
                    GpsApp.drawLocation(Optional.of(entry.location()), canvas, 4 + numWidth + 4, 20 + 26 * relativeIndex);
                }
                super.draw(blockEntity, canvas);
            }

            private Consumer<TardisControl> selectVisibleEntry(int index) {
                return controls -> {
                    if (controls.getTardis().setDestination(HistoryApp.this.history.get(this.currentPage * 3 + index).location(), false)) {
                        controls.setDestinationLocked(false, true);
                    }
                };
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("history_background"));
            }
        };
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"mini_tardis.app.mini_tardis.history.tooltip", (Object[])new Object[]{this.history.size()})).method_27696(class_2583.field_24360.method_10977(class_124.field_1063)));
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/history"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.HISTORY;
    }
}

