/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.DimensionsApp;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5536;

public class GpsApp
implements ScreenApp {
    public static final Codec<GpsApp> CODEC = Codec.unit(GpsApp::new);

    @Override
    public AppView getView(final TardisControl controls) {
        return new AppView(){

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                Either<TardisLocation, PartialTardisLocation> current = controls.getTardis().getCurrentLocation();
                DefaultFonts.VANILLA.drawText(canvas, "Current Location", 3, 4, 8.0, CanvasColors.WHITE);
                GpsApp.drawLocation(current, canvas, 3, 24);
                Optional<TardisLocation> destination = controls.getTardis().getDestination();
                DefaultFonts.VANILLA.drawText(canvas, "Destination", 3, 45, 8.0, CanvasColors.WHITE);
                GpsApp.drawLocation(destination, canvas, 3, 65);
                boolean isLocked = controls.isDestinationLocked();
                short color = isLocked ? CanvasColors.LIME_DULL : CanvasColors.RED_DULL;
                String lockedText = isLocked ? ">> Locked <<" : "|| Unlocked ||";
                int lockedWidth = DefaultFonts.VANILLA.getTextWidth(lockedText, 8.0);
                DefaultFonts.VANILLA.drawText(canvas, lockedText, 64 - lockedWidth / 2, 86, 8.0, color);
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("gps_background"));
            }

            @Override
            public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
                return false;
            }
        };
    }

    public static void drawLocation(Optional<TardisLocation> optionalLocation, DrawableCanvas canvas, int x, int y) {
        optionalLocation.ifPresentOrElse(location -> GpsApp.drawLocation(location, canvas, x, y), () -> DefaultFonts.VANILLA.drawText(canvas, "Unknown", x, y + 9, 8.0, CanvasColors.LIGHT_GRAY));
    }

    public static void drawLocation(Either<TardisLocation, PartialTardisLocation> eitherLocation, DrawableCanvas canvas, int x, int y) {
        eitherLocation.ifLeft(location -> GpsApp.drawLocation(location, canvas, x, y)).ifRight(partialLocation -> {
            DefaultFonts.VANILLA.drawText(canvas, "Unknown", x, y, 8.0, CanvasColors.LIGHT_GRAY);
            class_5321<class_1937> worldId = partialLocation.worldKey();
            DefaultFonts.VANILLA.drawText(canvas, DimensionsApp.translateWorldId(worldId).getString(), x, y + 9, 8.0, CanvasColors.LIGHT_GRAY);
        });
    }

    private static void drawLocation(TardisLocation location, DrawableCanvas canvas, int x, int y) {
        String xText = String.valueOf(location.pos().method_10263());
        String yText = String.valueOf(location.pos().method_10264());
        String zText = String.valueOf(location.pos().method_10260());
        String facingText = String.valueOf(location.facing().method_10151().toUpperCase().charAt(0));
        int spaceWidth = DefaultFonts.VANILLA.getTextWidth(" ", 8.0);
        DefaultFonts.VANILLA.drawText(canvas, xText, x, y, 8.0, CanvasColors.RED);
        int xWidth = DefaultFonts.VANILLA.getTextWidth(xText, 8.0);
        DefaultFonts.VANILLA.drawText(canvas, yText, x + xWidth + spaceWidth, y, 8.0, CanvasColors.LIGHT_BLUE);
        int yWidth = DefaultFonts.VANILLA.getTextWidth(yText, 8.0);
        DefaultFonts.VANILLA.drawText(canvas, zText, x + xWidth + spaceWidth + yWidth + spaceWidth, y, 8.0, CanvasColors.LIME);
        int zWidth = DefaultFonts.VANILLA.getTextWidth(zText, 8.0);
        short facingColor = location.facing().method_10148() != 0 ? CanvasColors.RED_DULL : (location.facing().method_10165() != 0 ? CanvasColors.LIME_DULL : CanvasColors.LIGHT_BLUE_DULL);
        DefaultFonts.VANILLA.drawText(canvas, facingText, x + xWidth + spaceWidth + yWidth + spaceWidth + zWidth + spaceWidth, y, 8.0, facingColor);
        class_5321<class_1937> worldId = location.worldKey();
        DefaultFonts.VANILLA.drawText(canvas, DimensionsApp.translateWorldId(worldId).getString(), x, y + 9, 8.0, CanvasColors.LIGHT_GRAY);
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/gps"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.GPS;
    }
}

