/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.SubView;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.FloppyBirdElement;
import dev.enjarai.minitardis.component.screen.element.FloppyPipeElement;
import dev.enjarai.minitardis.component.screen.element.ResizableButtonElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5536;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;

public class FloppyBirdApp
implements ScreenApp {
    public static final Codec<FloppyBirdApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.INT).optionalFieldOf("high_scores", Map.of()).forGetter(app -> app.highScores)).apply((Applicative)instance, FloppyBirdApp::new));
    public static final int WIN_DURATION = 30;
    public static final int PIPE_SPACING = 42;
    private HashMap<UUID, Integer> highScores;

    private FloppyBirdApp(Map<UUID, Integer> highScores) {
        this.highScores = new HashMap<UUID, Integer>(highScores);
    }

    public FloppyBirdApp() {
        this(Map.of());
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(controls){
            final class_5819 gamerRandom;
            final FloppyBirdElement ballElement;
            final ResizableButtonElement restartButton;
            final ResizableButtonElement highScoresButton;
            final ResizableButtonElement backButton;
            int frameCounter;
            int spacingCounter;
            boolean gameOver;
            int deadFrames;
            boolean hanging;
            int points;
            int framesSincePoint;
            int currentLevel;
            int pipesSpawned;
            int winningLevelFrames;
            boolean beatHighScore;
            @Nullable
            List<Pair<String, Integer>> showHighScores;
            @Nullable
            class_3222 lastInteractor;
            {
                this.gamerRandom = new class_6575((long)this.controls.getTardis().getRandom().method_43054());
                this.ballElement = new FloppyBirdElement(32, 32);
                this.restartButton = new ResizableButtonElement(40, 42, 44, "Restart", controls1 -> {
                    this.gameOver = false;
                    this.points = 0;
                    this.currentLevel = 1;
                    this.beatHighScore = false;
                    this.showHighScores = null;
                    this.resetLevel();
                    this.children.removeIf(FloppyPipeElement.class::isInstance);
                });
                this.highScoresButton = new ResizableButtonElement(30, 58, 64, "High scores", controls1 -> {
                    this.showHighScores = FloppyBirdApp.this.highScores.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue).reversed()).map(e -> Pair.of((Object)controls1.getTardis().getServer().method_3793().method_14512((UUID)e.getKey()).map(GameProfile::getName).orElse("Unknown"), (Object)((Integer)e.getValue()))).toList();
                });
                this.backButton = new ResizableButtonElement(48, 4, 28, "Back", controls1 -> {
                    this.showHighScores = null;
                });
                this.spacingCounter = 42;
                this.hanging = true;
                this.framesSincePoint = 999;
                this.currentLevel = 1;
                this.winningLevelFrames = -1;
                this.addElement(this.ballElement);
                this.addElement(this.restartButton);
                this.addElement(this.highScoresButton);
                this.addElement(this.backButton);
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                ++this.frameCounter;
                ++this.framesSincePoint;
                if (!this.gameOver) {
                    this.deadFrames = 0;
                    ListIterator iterator = this.children.listIterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof FloppyPipeElement)) continue;
                        FloppyPipeElement pipe = (FloppyPipeElement)e;
                        if (this.ballElement.overlapsWith(pipe) && this.winningLevelFrames < 0) {
                            this.gameOver();
                        }
                        --pipe.x;
                        if (pipe.x < -10) {
                            iterator.remove();
                        }
                        if (pipe.y >= 0 || pipe.x != this.ballElement.x) continue;
                        ++this.points;
                        this.framesSincePoint = 0;
                    }
                    ++this.spacingCounter;
                    if (this.spacingCounter >= 42 && this.pipesSpawned < 10) {
                        this.spacingCounter = 0;
                        int holeSize = this.gamerRandom.method_39332(25, 40);
                        int vOffset = this.gamerRandom.method_39332(0, 58 - holeSize);
                        FloppyPipeElement lowerPipe = new FloppyPipeElement(124, 8 + vOffset + holeSize);
                        FloppyPipeElement upperPipe = new FloppyPipeElement(124, 8 + vOffset - lowerPipe.height);
                        this.children.add(0, lowerPipe);
                        this.children.add(0, upperPipe);
                        ++this.pipesSpawned;
                    }
                    if (this.ballElement.gradualY >= 72.0f || this.ballElement.gradualY <= -4.0f) {
                        this.gameOver();
                    }
                    if (this.points == this.currentLevel * 10 && this.winningLevelFrames < 0) {
                        this.winningLevelFrames = 0;
                    }
                    switch (this.framesSincePoint) {
                        case 1: {
                            blockEntity.playClickSound(1.2f);
                            break;
                        }
                        case 5: {
                            blockEntity.playClickSound(1.3f);
                        }
                    }
                } else {
                    ++this.deadFrames;
                    switch (this.deadFrames) {
                        case 1: {
                            blockEntity.playClickSound(0.9f);
                            break;
                        }
                        case 5: {
                            blockEntity.playClickSound(0.8f);
                            break;
                        }
                        case 9: {
                            blockEntity.playClickSound(0.7f);
                        }
                    }
                }
                if (this.frameCounter == 40) {
                    this.hanging = false;
                }
                if (this.winningLevelFrames >= 0) {
                    ++this.winningLevelFrames;
                    this.ballElement.gradualY = class_3532.method_16439((float)((float)this.winningLevelFrames / 30.0f), (float)this.ballElement.gradualY, (float)32.0f);
                    switch (this.winningLevelFrames) {
                        case 1: {
                            blockEntity.playClickSound(1.1f);
                            break;
                        }
                        case 5: {
                            blockEntity.playClickSound(1.3f);
                            break;
                        }
                        case 9: {
                            blockEntity.playClickSound(1.5f);
                        }
                    }
                    if (this.winningLevelFrames >= 30) {
                        this.resetLevel();
                        ++this.currentLevel;
                    }
                } else {
                    this.ballElement.deltaY = this.ballElement.deltaY + (this.hanging ? 0.0f : (this.gameOver ? 1.0f : 0.3f));
                }
                this.restartButton.visible = this.deadFrames >= 12 && this.showHighScores == null;
                this.highScoresButton.visible = this.deadFrames >= 12 && this.showHighScores == null;
                this.backButton.visible = this.deadFrames >= 12 && this.showHighScores != null;
                super.draw(blockEntity, new SubView(canvas, 2, 18, 124, 76));
                DefaultFonts.VANILLA.drawText(canvas, "Pts: " + this.points, 5, 5, 8.0, CanvasColors.WHITE);
                DefaultFonts.VANILLA.drawText(canvas, "Lv: " + this.currentLevel, 64, 5, 8.0, CanvasColors.WHITE);
                if (this.deadFrames >= 12) {
                    if (this.showHighScores == null) {
                        TardisCanvasUtils.drawCenteredText(canvas, "Game Over", 64, 32, CanvasColors.GRAY);
                        if (this.lastInteractor != null) {
                            TardisCanvasUtils.drawCenteredText(canvas, (String)(this.beatHighScore ? "New High Score!" : "High Score: " + String.valueOf(FloppyBirdApp.this.highScores.getOrDefault(this.lastInteractor.method_5667(), 0))), 64, 44, CanvasColors.GRAY);
                        }
                    } else {
                        class_1937 world = blockEntity.method_10997();
                        if (world != null) {
                            for (int i = 0; i < Math.min(this.showHighScores.size(), 5); ++i) {
                                Pair<String, Integer> entry = this.showHighScores.get(i);
                                TardisCanvasUtils.drawCenteredText(canvas, (String)entry.getFirst() + ": " + String.valueOf(entry.getSecond()), 64, 40 + i * 12, CanvasColors.GRAY);
                            }
                        }
                    }
                }
            }

            private void gameOver() {
                this.gameOver = true;
                this.ballElement.deltaY = -6.0f;
                if (this.lastInteractor != null && this.points > FloppyBirdApp.this.highScores.getOrDefault(this.lastInteractor.method_5667(), 0)) {
                    this.beatHighScore = true;
                    FloppyBirdApp.this.highScores.put(this.lastInteractor.method_5667(), this.points);
                }
            }

            private void resetLevel() {
                this.frameCounter = 0;
                this.hanging = true;
                this.spacingCounter = 42;
                this.pipesSpawned = 0;
                this.winningLevelFrames = -1;
                this.ballElement.gradualX = 32.0f;
                this.ballElement.gradualY = 32.0f;
                this.ballElement.deltaX = 0.0f;
                this.ballElement.deltaY = 0.0f;
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(2, 18, TardisCanvasUtils.getSprite("floppy_bird_background"));
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("status_background"));
            }

            @Override
            public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
                this.lastInteractor = player;
                if (!this.gameOver && this.winningLevelFrames < 0) {
                    this.ballElement.deltaY = -2.5f;
                    this.hanging = false;
                    blockEntity.playClickSound(1.0f);
                    return true;
                }
                return super.onClick(blockEntity, player, type, x - 2, y - 18);
            }
        };
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"mini_tardis.app.mini_tardis.floppy_bird.tooltip", (Object[])new Object[]{this.highScores.size()})).method_27696(class_2583.field_24360.method_10977(class_124.field_1063)));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.FLOPPY_BIRD;
    }
}

