/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ElementHoldingView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import dev.enjarai.minitardis.component.screen.element.AppElement;
import dev.enjarai.minitardis.component.screen.element.DimensionStarElement;
import dev.enjarai.minitardis.component.screen.element.SmallButtonElement;
import dev.enjarai.minitardis.data.RandomAppLootFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_7924;
import org.apache.commons.lang3.text.WordUtils;

public class DimensionsApp
implements ScreenApp {
    public static final Codec<DimensionsApp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).listOf().optionalFieldOf("accessible_dimensions", List.of()).forGetter(app -> app.accessibleDimensions)).apply((Applicative)instance, DimensionsApp::new));
    public final List<class_5321<class_1937>> accessibleDimensions;

    private DimensionsApp(List<class_5321<class_1937>> accessibleDimensions) {
        this.accessibleDimensions = new ArrayList<class_5321<class_1937>>(accessibleDimensions);
    }

    public DimensionsApp() {
        this.accessibleDimensions = new ArrayList<class_5321<class_1937>>();
    }

    @Override
    public AppView getView(TardisControl controls) {
        return new ElementHoldingView(controls){
            private final class_5819 deterministicRandom;
            private final SmallButtonElement saveDimButton;
            {
                this.deterministicRandom = new class_6575(69420L);
                this.saveDimButton = this.addElement(new SmallButtonElement(68, 2, "Add", controls1 -> controls1.getTardis().getDestination().ifPresent(destination -> {
                    if (!DimensionsApp.this.accessibleDimensions.contains(destination.worldKey())) {
                        DimensionsApp.this.accessibleDimensions.add(destination.worldKey());
                        this.refreshStars();
                    }
                })));
                this.controls.getTardis().getServer().method_29435().stream().filter(key -> DimensionsApp.this.canAddAsAccessible((class_5321<class_1937>)key)).sorted(Comparator.comparing(class_5321::method_29177)).forEachOrdered(world -> {
                    DimensionStarElement star = new DimensionStarElement(0, 0, (class_5321<class_1937>)world);
                    int timeout = 0;
                    do {
                        star.x = this.deterministicRandom.method_39332(2, 115);
                        star.y = this.deterministicRandom.method_39332(18, 83);
                    } while (this.children.stream().anyMatch(el -> {
                        DimensionStarElement pel;
                        return el instanceof DimensionStarElement && star.overlapsWith(pel = (DimensionStarElement)el);
                    }) && ++timeout <= 10);
                    star.visible = DimensionsApp.this.accessibleDimensions.contains(world);
                    this.addElement(star);
                });
            }

            @Override
            public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                this.saveDimButton.visible = false;
                this.controls.getTardis().getDestination().ifPresentOrElse(destination -> {
                    class_5321<class_1937> worldId = destination.worldKey();
                    if (!DimensionsApp.this.accessibleDimensions.contains(worldId) && !Tardis.isTardis(worldId)) {
                        this.saveDimButton.visible = true;
                        DefaultFonts.VANILLA.drawText(canvas, "Unknown", 5, 6, 8.0, CanvasColors.LIGHT_GRAY);
                    } else {
                        DefaultFonts.VANILLA.drawText(canvas, DimensionsApp.translateWorldId(worldId).getString(), 5, 6, 8.0, CanvasColors.LIGHT_GRAY);
                    }
                }, () -> DefaultFonts.VANILLA.drawText(canvas, "None", 5, 6, 8.0, CanvasColors.LIGHT_GRAY));
                super.draw(blockEntity, canvas);
            }

            private void refreshStars() {
                for (AppElement element : this.children()) {
                    if (!(element instanceof DimensionStarElement)) continue;
                    DimensionStarElement star = (DimensionStarElement)element;
                    star.visible = DimensionsApp.this.accessibleDimensions.contains(star.worldKey);
                }
            }

            @Override
            public void drawBackground(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
                canvas.draw(0, 0, TardisCanvasUtils.getSprite("dimensions_background"));
            }
        };
    }

    public boolean canAddAsAccessible(class_5321<class_1937> worldKey) {
        return !worldKey.method_29177().method_12832().startsWith("tardis/");
    }

    public static class_2561 translateWorldId(class_5321<class_1937> key) {
        class_2960 id = key.method_29177();
        if (Tardis.isTardis(key)) {
            return class_2561.method_43471((String)"dimension.mini_tardis.tardis_generic");
        }
        return class_2561.method_48321((String)("dimension." + id.method_12836() + "." + id.method_12832()), (String)WordUtils.capitalize((String)id.method_12832().replace('_', ' ')));
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/dimensions"));
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip) {
        for (class_5321<class_1937> dimension : this.accessibleDimensions) {
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852(DimensionsApp.translateWorldId(dimension)).method_27696(class_2583.field_24360.method_10977(class_124.field_1063)));
        }
    }

    @Override
    public void applyLootModifications(class_47 context, RandomAppLootFunction lootFunction) {
        this.accessibleDimensions.add((class_5321<class_1937>)context.method_299().method_27983());
        for (class_5321<class_1937> dimension : lootFunction.additionalDimensions()) {
            if (this.accessibleDimensions.contains(dimension)) continue;
            this.accessibleDimensions.add(dimension);
        }
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.DIMENSIONS;
    }
}

