/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.screen.app;

import com.mojang.serialization.Codec;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.BadApple;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5536;

public class BadAppleApp
implements ScreenApp {
    public static final Codec<BadAppleApp> CODEC = Codec.unit(BadAppleApp::new);
    public static final short[] COLORS = new short[]{CanvasUtils.toLimitedColor(0x111111), CanvasUtils.toLimitedColor(0x333333), CanvasUtils.toLimitedColor(0x555555), CanvasUtils.toLimitedColor(0x777777), CanvasUtils.toLimitedColor(0x999999), CanvasUtils.toLimitedColor(0xBBBBBB), CanvasUtils.toLimitedColor(0xDDDDDD), CanvasUtils.toLimitedColor(0xFFFFFF)};

    @Override
    public AppView getView(TardisControl controls) {
        return new BadAppleView();
    }

    public static short getCanvasColor(int frame, int x, int y) {
        byte pixel = BadApple.getPixel(frame, x, y);
        return COLORS[pixel];
    }

    @Override
    public void drawIcon(TardisControl controls, ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("app/bad_apple"));
    }

    @Override
    public ScreenAppType<?> getType() {
        return ScreenAppTypes.BAD_APPLE;
    }

    public static class BadAppleView
    implements AppView {
        int badAppleFrameCounter;

        @Override
        public void draw(ScreenBlockEntity blockEntity, DrawableCanvas canvas) {
            int frame = class_3532.method_15340((int)this.badAppleFrameCounter, (int)0, (int)BadApple.getFrameCount());
            for (int x = 0; x < BadApple.width; ++x) {
                for (int y = 0; y < BadApple.height; ++y) {
                    short color = BadAppleApp.getCanvasColor(frame, x, y);
                    canvas.setRaw((int)((float)(x * BadApple.width) / 128.0f), (int)((float)(y * BadApple.height) / 96.0f), color);
                }
            }
            ++this.badAppleFrameCounter;
            if (this.badAppleFrameCounter >= BadApple.getFrameCount()) {
                this.endAnimation(blockEntity);
            }
        }

        @Override
        public void screenOpen(ScreenBlockEntity blockEntity) {
            this.badAppleFrameCounter = -5;
            class_2338 pos = blockEntity.method_11016();
            blockEntity.method_10997().method_8396(null, pos, ModSounds.BAD_APPLE, class_3419.field_15247, 1.0f, 1.0f);
        }

        @Override
        public void screenClose(ScreenBlockEntity blockEntity) {
            this.badAppleFrameCounter = 0;
            class_2770 stopSoundS2CPacket = new class_2770(ModSounds.BAD_APPLE.method_14833(), class_3419.field_15247);
            for (class_1657 player : blockEntity.method_10997().method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)stopSoundS2CPacket);
            }
        }

        public void endAnimation(ScreenBlockEntity blockEntity) {
            blockEntity.closeApp();
        }

        @Override
        public boolean onClick(ScreenBlockEntity blockEntity, class_3222 player, class_5536 type, int x, int y) {
            return false;
        }
    }
}

