/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.HistoryEntry;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.CrashingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import dev.enjarai.minitardis.component.flight.TransitionalFlightState;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class TakingOffState
extends TransitionalFlightState {
    public static final MapCodec<TakingOffState> CODEC = Codec.INT.xmap(TakingOffState::new, s -> s.ticksPassed).fieldOf("ticks_passed");
    public static final class_2960 ID = MiniTardis.id("taking_off");

    private TakingOffState(int ticksPassed) {
        super(ticksPassed);
    }

    public TakingOffState() {
        this(0);
    }

    @Override
    public void init(Tardis tardis) {
        this.playForInteriorAndExterior(tardis, ModSounds.TARDIS_TAKEOFF, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public void complete(Tardis tardis) {
        tardis.getCurrentLandedLocation().ifPresent(location -> tardis.addHistoryEntry(new HistoryEntry((TardisLocation)location)));
        tardis.setCurrentLocation(new PartialTardisLocation(tardis.getExteriorWorldKey()));
    }

    @Override
    public FlightState tick(Tardis tardis) {
        if (tardis.getStability() <= 0 && tardis.getCurrentLandedLocation().isPresent()) {
            return new CrashingState(tardis.getCurrentLandedLocation().get());
        }
        if (this.ticksPassed % 2 == 0 && !tardis.addOrDrainFuel(-1)) {
            tardis.getControls().majorMalfunction();
            return this;
        }
        return super.tick(tardis);
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return 1.0f;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof SearchingForLandingState) {
            tardis.getControls().majorMalfunction();
        } else {
            tardis.getControls().moderateMalfunction();
        }
        return false;
    }

    @Override
    public FlightState getNextState(Tardis tardis) {
        return new FlyingState(tardis.getCurrentLandedLocation().flatMap(current -> tardis.getDestination().map(destination -> Math.sqrt(current.pos().method_10262((class_2382)destination.pos())))).orElse(0.0).intValue());
    }

    @Override
    public int getTransitionDuration(Tardis tardis) {
        return 200;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public byte getExteriorAlpha(Tardis tardis) {
        double vwoompWave = Math.sin((double)this.ticksPassed / 6.0 + 1.8) * 0.2 + 1.0;
        return (byte)((double)((this.getTransitionDuration(tardis) - this.ticksPassed) / (this.getTransitionDuration(tardis) / 15)) * vwoompWave);
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return FlyingState.spinnyLighting(order, this.ticksPassed);
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

