/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.BeingInterdictedState;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import dev.enjarai.minitardis.component.flight.TakingOffState;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class SuspendedFlightState
implements FlightState {
    public static final MapCodec<SuspendedFlightState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("errorLoops").forGetter(s -> s.errorLoops), (App)Codec.INT.optionalFieldOf("distance", (Object)0).forGetter(s -> s.distance)).apply((Applicative)instance, SuspendedFlightState::new));
    public static final class_2960 ID = MiniTardis.id("suspended_flight");
    static final int SOUND_LOOP_LENGTH = 32;
    private static final int AFTERSHAKE_LENGTH = 80;
    int flyingTicks;
    int aftershakeTicks;
    public int errorLoops;
    public int distance;

    private SuspendedFlightState(int flyingTicks, int errorLoops, int distance) {
        this.flyingTicks = flyingTicks;
        this.errorLoops = errorLoops;
        this.distance = distance;
    }

    public SuspendedFlightState() {
        this(0, 0, 0);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        int stability;
        ++this.flyingTicks;
        ++this.aftershakeTicks;
        if (this.flyingTicks % 32 == 0) {
            boolean isError;
            boolean bl = isError = this.errorLoops > 0;
            if (isError) {
                --this.errorLoops;
                float errorPitch = tardis.getInteriorWorld().method_8409().method_43057() - 0.5f;
                this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP_ERROR, class_3419.field_15245, 0.2f, errorPitch);
            }
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP, class_3419.field_15245, 0.05f, 1.0f);
        }
        if ((stability = tardis.getStability()) <= 0) {
            return new SearchingForLandingState(true, tardis.getRandom().method_43054());
        }
        if (this.flyingTicks % 2 == 0 && stability < 1000) {
            tardis.setStability(stability + 1);
        }
        if (this.flyingTicks % 100 == 0 && !tardis.addOrDrainFuel(-1)) {
            tardis.getControls().moderateMalfunction();
            return this;
        }
        return this;
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return Math.max((float)(80 - this.aftershakeTicks) / 80.0f, 0.0f);
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof FlyingState) {
            FlyingState flyingState = (FlyingState)newState;
            flyingState.flyingTicks = this.flyingTicks;
            flyingState.setOffsets(this.distance);
            return true;
        }
        if (newState instanceof DriftingState) {
            DriftingState driftingState = (DriftingState)newState;
            driftingState.flyingTicks = this.flyingTicks;
            return true;
        }
        if (newState instanceof BeingInterdictedState) {
            BeingInterdictedState interceptedState = (BeingInterdictedState)newState;
            interceptedState.flyingTicks = this.flyingTicks;
            return true;
        }
        if (newState instanceof TakingOffState) {
            return false;
        }
        tardis.getControls().minorMalfunction();
        return false;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean canBeInterdicted(Tardis tardis) {
        return true;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return FlyingState.spinnyLighting(order, this.flyingTicks);
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

