/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.ModBlocks;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.CrashingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.LandingState;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5819;

public class SearchingForLandingState
implements FlightState {
    public static final MapCodec<SearchingForLandingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("searching_ticks").forGetter(s -> s.searchingTicks), (App)Codec.BOOL.fieldOf("crashing").forGetter(s -> s.crashing), (App)Codec.INT.fieldOf("error_distance").forGetter(s -> s.errorDistance)).apply((Applicative)instance, SearchingForLandingState::new));
    public static final class_2960 ID = MiniTardis.id("searching_for_landing");
    private static final int BLOCKS_PER_TICK = 256;
    private static final int MAX_SEARCH_RANGE = 24;
    int flyingTicks;
    private int searchingTicks;
    final boolean crashing;
    int errorDistance;
    private Iterator<class_2338> searchIterator;

    private SearchingForLandingState(int flyingTicks, int searchingTicks, boolean crashing, int errorDistance) {
        this.flyingTicks = flyingTicks;
        this.searchingTicks = searchingTicks;
        this.crashing = crashing;
        this.errorDistance = errorDistance;
    }

    public SearchingForLandingState(boolean crashing, int errorDistance) {
        this(0, 0, crashing, FlyingState.trimDistance(errorDistance));
    }

    @Override
    public FlightState tick(Tardis tardis) {
        Optional<TardisLocation> maybeDestination;
        ++this.flyingTicks;
        if (this.flyingTicks % 32 == 0) {
            float pitch = 1.0f;
            if (this.crashing) {
                pitch += tardis.getInteriorWorld().method_8409().method_43057() - 0.5f;
            }
            this.playForInterior(tardis, this.crashing ? ModSounds.TARDIS_FLY_LOOP_ERROR : ModSounds.TARDIS_FLY_LOOP, class_3419.field_15245, this.crashing ? 1.0f : 0.6f, pitch);
        }
        if ((maybeDestination = tardis.getDestination()).isPresent() && (maybeDestination.get().worldKey().equals(tardis.getExteriorWorldKey()) || this.crashing)) {
            TardisLocation destination = this.crashing ? maybeDestination.get().with(tardis.getExteriorWorldKey()) : maybeDestination.get();
            class_3218 destinationWorld = destination.getWorld(tardis.getServer());
            if (this.searchIterator == null) {
                class_5819 random = tardis.getRandom();
                destination = destination.with(destination.pos().method_10069(random.method_39332(-this.errorDistance, this.errorDistance), 0, random.method_39332(-this.errorDistance, this.errorDistance)));
                int minY = destinationWorld.method_31607();
                int maxY = minY + destinationWorld.method_32819();
                int x = destination.pos().method_10263();
                int z = destination.pos().method_10260();
                int heightMapPos = destinationWorld.method_8497(class_4076.method_18675((int)x), class_4076.method_18675((int)z)).method_12005(class_2902.class_2903.field_13203, x & 0xF, z & 0xF);
                destination = destination.with(destination.pos().method_33096(class_3532.method_15340((int)destination.pos().method_10264(), (int)minY, (int)Math.min(maxY, heightMapPos))));
                this.searchIterator = class_2338.method_25996((class_2338)destination.pos(), (int)24, (int)24, (int)24).iterator();
            }
            int i = 0;
            while (i < 256) {
                if (!this.searchIterator.hasNext()) {
                    tardis.getControls().moderateMalfunction();
                    class_5819 random = tardis.getInteriorWorld().method_8409();
                    TardisLocation location = destination.with(destination.pos().method_33096(class_3532.method_15340((int)destination.pos().method_10264(), (int)(destinationWorld.method_31607() + 24 + 8), (int)(destinationWorld.method_31607() + destinationWorld.method_32819() - 24 - 8))).method_10069(random.method_39332(-24, 24), random.method_39332(-24, 24), random.method_39332(-24, 24)));
                    this.spawnSafetyStructure(location.getWorld(tardis.getServer()), location.pos());
                    return this.crashing ? new CrashingState(location) : new LandingState(location);
                }
                class_2338 pos = this.searchIterator.next();
                if (destinationWorld.method_31606(pos)) continue;
                ++i;
                TardisLocation location = destination.with(pos);
                if (!tardis.canLandAt(location)) continue;
                return this.crashing ? new CrashingState(location) : new LandingState(location);
            }
            ++this.searchingTicks;
        } else {
            tardis.getControls().minorMalfunction();
            FlyingState flyingState = new FlyingState(this.errorDistance);
            flyingState.errorLoops = 2;
            flyingState.flyingTicks = this.flyingTicks;
            return flyingState;
        }
        return this;
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return this.crashing ? 3.0f : 0.5f;
    }

    protected void spawnSafetyStructure(class_3218 world, class_2338 pos) {
        for (class_2338 floorPos : class_2338.method_10097((class_2338)pos.method_10074().method_10067().method_10095(), (class_2338)pos.method_10074().method_10078().method_10072())) {
            if (world.method_8320(floorPos).method_26206((class_1922)world, floorPos, class_2350.field_11036)) continue;
            world.method_8501(floorPos, ModBlocks.TARDIS_PLATING.method_9564());
        }
        for (class_2338 roomPos : class_2338.method_10097((class_2338)pos.method_10067().method_10095(), (class_2338)pos.method_10086(2).method_10078().method_10072())) {
            if (world.method_8320(roomPos).method_26220((class_1922)world, roomPos).method_1110()) continue;
            world.method_8501(roomPos, class_2246.field_10124.method_9564());
        }
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        return false;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        tardis.getControls().moderateMalfunction();
        return false;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        if (this.crashing) {
            return this.flyingTicks / 5 % 3 == --order / 4;
        }
        return FlyingState.spinnyLighting(order, this.flyingTicks);
    }

    @Override
    public class_2561 getName() {
        return this.crashing ? class_2561.method_43471((String)"mini_tardis.state.mini_tardis.searching_for_landing.crashing") : FlightState.super.getName();
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

