/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.LandedState;
import net.minecraft.class_2960;

public class RefuelingState
implements FlightState {
    public static final MapCodec<RefuelingState> CODEC = Codec.INT.xmap(RefuelingState::new, s -> s.refuelingCounter).fieldOf("refueling_counter");
    public static final class_2960 ID = MiniTardis.id("refueling");
    private int refuelingCounter;

    private RefuelingState(int refuelingCounter) {
        this.refuelingCounter = refuelingCounter;
    }

    public RefuelingState() {
        this(0);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        int stability = tardis.getStability();
        if (stability < 1000) {
            tardis.setStability(stability + 1);
        }
        if (this.refuelingCounter > 20) {
            this.refuelingCounter = 0;
            if (!tardis.addOrDrainFuel(1)) {
                return new LandedState();
            }
        }
        ++this.refuelingCounter;
        return this;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        return newState instanceof LandedState;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

