/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.LandedState;
import dev.enjarai.minitardis.component.flight.TransitionalFlightState;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class LandingState
extends TransitionalFlightState {
    public static final MapCodec<LandingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("ticks_passed").forGetter(s -> s.ticksPassed), (App)TardisLocation.CODEC.fieldOf("landing_destination").forGetter(s -> s.landingDestination), (App)Codec.BOOL.optionalFieldOf("first_landing", (Object)false).forGetter(s -> s.firstLanding)).apply((Applicative)instance, LandingState::new));
    public static final class_2960 ID = MiniTardis.id("landing");
    private final TardisLocation landingDestination;
    private final boolean firstLanding;

    private LandingState(int ticksPassed, TardisLocation landingDestination, boolean firstLanding) {
        super(ticksPassed);
        this.landingDestination = landingDestination;
        this.firstLanding = firstLanding;
    }

    public LandingState(TardisLocation landingDestination) {
        this(0, landingDestination, false);
    }

    public LandingState(TardisLocation landingDestination, boolean firstLanding) {
        this(0, landingDestination, firstLanding);
    }

    @Override
    public void init(Tardis tardis) {
        tardis.setCurrentLocation(this.landingDestination);
        this.playForInteriorAndExterior(tardis, ModSounds.TARDIS_LANDING, class_3419.field_15245, 1.0f, 1.0f);
        tardis.buildExterior();
    }

    @Override
    public FlightState tick(Tardis tardis) {
        if (tardis.getCurrentLandedLocation().map(tardis::canLandAt).orElse(false).booleanValue()) {
            tardis.getControls().moderateMalfunction();
            tardis.setCurrentLocation(new PartialTardisLocation(tardis.getExteriorWorldKey()));
            return new FlyingState(tardis.getRandom().method_43054());
        }
        if (this.ticksPassed % 2 == 0) {
            tardis.addOrDrainFuel(-1);
        }
        return super.tick(tardis);
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return 1.0f;
    }

    @Override
    public void complete(Tardis tardis) {
        tardis.getControls().setDestinationLocked(false, true);
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        tardis.getControls().moderateMalfunction();
        return false;
    }

    @Override
    public FlightState getNextState(Tardis tardis) {
        return this.firstLanding ? new DisabledState() : new LandedState();
    }

    @Override
    public int getTransitionDuration(Tardis tardis) {
        return 180;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        tardis.getControls().moderateMalfunction();
        return false;
    }

    @Override
    public byte getExteriorAlpha(Tardis tardis) {
        double vwoompWave = Math.sin((double)this.ticksPassed / 5.0) * 0.2 + 1.0;
        return (byte)((double)(this.ticksPassed / (this.getTransitionDuration(tardis) / 15)) * vwoompWave);
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return !this.firstLanding && FlyingState.spinnyLighting(order, this.ticksPassed);
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

