/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.RefuelingState;
import dev.enjarai.minitardis.component.flight.TakingOffState;
import net.minecraft.class_2960;

public class LandedState
implements FlightState {
    public static final MapCodec<LandedState> CODEC = MapCodec.unit(LandedState::new);
    public static final class_2960 ID = MiniTardis.id("landed");

    @Override
    public FlightState tick(Tardis tardis) {
        int stability = tardis.getStability();
        if (stability < 1000) {
            tardis.setStability(stability + 1);
        }
        if (tardis.getControls().areEnergyConduitsUnlocked() && tardis.getInteriorWorld().method_8510() % 40L == 0L) {
            tardis.addOrDrainFuel(-1);
        }
        return this;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof TakingOffState && tardis.getControls().isDestinationLocked() && tardis.getControls().areEnergyConduitsUnlocked()) {
            return true;
        }
        if (newState instanceof DisabledState) {
            return true;
        }
        return newState instanceof RefuelingState && !tardis.getControls().areEnergyConduitsUnlocked();
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

