/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.BeingInterdictedState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.InterdictState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_4844;

public class InterdictingState
extends InterdictState {
    public static final MapCodec<InterdictingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4844.field_40825.fieldOf("other_tardis").forGetter(s -> s.otherTardis), (App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("phases_complete").forGetter(s -> s.phasesComplete), (App)Codec.INT.fieldOf("phase_ticks").forGetter(s -> s.phaseTicks), (App)Codec.INT.fieldOf("offset_x").forGetter(s -> s.offsetX), (App)Codec.INT.fieldOf("offset_y").forGetter(s -> s.offsetY)).apply((Applicative)instance, InterdictingState::new));
    public static final class_2960 ID = MiniTardis.id("interdicting");

    protected InterdictingState(UUID otherTardis, int flyingTicks, int phasesComplete, int phaseTicks, int offsetX, int offsetY) {
        super(otherTardis, flyingTicks, phasesComplete, phaseTicks, offsetX, offsetY);
    }

    public InterdictingState(UUID otherTardis) {
        super(otherTardis);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        Optional<Tardis> other = tardis.getHolder().getTardis(this.otherTardis);
        if (other.isEmpty()) {
            tardis.getControls().majorMalfunction();
            return new SearchingForLandingState(true, tardis.getRandom().method_43054());
        }
        if (other.get().getState(BeingInterdictedState.class).isEmpty() && !other.get().suggestStateTransition(new BeingInterdictedState(tardis.uuid()))) {
            tardis.getControls().moderateMalfunction();
            return this.completeMinigame(tardis);
        }
        return super.tick(tardis);
    }

    @Override
    protected FlightState completeMinigame(Tardis tardis) {
        tardis.getControls().setDestinationLocked(true, true);
        tardis.getDestination().ifPresent(destination -> tardis.setCurrentLocation(new PartialTardisLocation(destination.worldKey())));
        SearchingForLandingState newState = new SearchingForLandingState(false, 0);
        newState.flyingTicks = this.flyingTicks;
        return newState;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof SearchingForLandingState) {
            SearchingForLandingState landingState = (SearchingForLandingState)newState;
            if (landingState.crashing) {
                landingState.flyingTicks = this.flyingTicks;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTargetX() {
        return 0;
    }

    @Override
    public int getTargetY() {
        return 0;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

