/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.RespondsToFlyLever;
import dev.enjarai.minitardis.component.flight.RespondsToNudging;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public abstract class InterdictState
implements FlightState,
RespondsToFlyLever,
RespondsToNudging {
    public static final int PHASES = 6;
    public static final int MAX_X_OFFSET = 4;
    public static final int MAX_Y_OFFSET = 2;
    protected final UUID otherTardis;
    protected int phasesComplete;
    protected int phaseTicks;
    int flyingTicks;
    protected int offsetX;
    protected int offsetY;

    protected InterdictState(UUID otherTardis, int flyingTicks, int phasesComplete, int phaseTicks, int offsetX, int offsetY) {
        this.otherTardis = otherTardis;
        this.flyingTicks = flyingTicks;
        this.phasesComplete = phasesComplete;
        this.phaseTicks = phaseTicks;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public InterdictState(UUID otherTardis) {
        this(otherTardis, 0, 0, 0, 0, 0);
    }

    @Override
    public void init(Tardis tardis) {
        this.shuffleOffsets(tardis);
    }

    public void shuffleOffsets(Tardis tardis) {
        do {
            this.offsetX = tardis.getRandom().method_39332(-4, 4);
            this.offsetY = tardis.getRandom().method_39332(-2, 2);
        } while (this.offsetX == this.getTargetX() && this.offsetY == this.getTargetY());
    }

    @Override
    public FlightState tick(Tardis tardis) {
        ++this.flyingTicks;
        ++this.phaseTicks;
        if (this.flyingTicks % 32 == 0) {
            float errorPitch = tardis.getInteriorWorld().method_8409().method_43057() - 0.5f;
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP_ERROR, class_3419.field_15245, 0.6f, errorPitch);
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP, class_3419.field_15245, 0.6f, 1.0f);
        }
        if (this.phasesComplete >= 6) {
            if (this.phaseTicks == 11) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 0.9f);
            } else if (this.phaseTicks == 16) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 1.1f);
            } else if (this.phaseTicks >= 21) {
                return this.completeMinigame(tardis);
            }
        }
        if (this.flyingTicks % 2 == 0 && !tardis.addOrDrainFuel(-1)) {
            tardis.getControls().moderateMalfunction();
        }
        if (tardis.getStability() <= 0) {
            return new SearchingForLandingState(true, tardis.getRandom().method_43054());
        }
        return this;
    }

    protected abstract FlightState completeMinigame(Tardis var1);

    @Override
    public boolean toggleFlyLever(Tardis tardis, boolean active) {
        if (this.offsetX == this.getTargetX() && this.offsetY == this.getTargetY()) {
            this.completePhase(tardis);
            return true;
        }
        tardis.getControls().minorMalfunction();
        this.shuffleOffsets(tardis);
        return false;
    }

    protected void completePhase(Tardis tardis) {
        ++this.phasesComplete;
        this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
        if (this.phasesComplete < 6) {
            this.shuffleOffsets(tardis);
        }
    }

    @Override
    public boolean nudgeDestination(Tardis tardis, class_2350 direction) {
        class_2382 vec = direction.method_10163();
        int shiftX = -vec.method_10263();
        int shiftY = -vec.method_10260();
        this.offsetX = Math.clamp((long)(this.offsetX + shiftX), -4, 4);
        this.offsetY = Math.clamp((long)(this.offsetY + shiftY), -2, 2);
        return true;
    }

    public abstract int getTargetX();

    public abstract int getTargetY();

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getPhasesComplete() {
        return this.phasesComplete;
    }

    public Optional<InterdictState> getLinkedState(Tardis tardis) {
        return tardis.getHolder().getTardis(this.otherTardis).flatMap(t -> t.getState(InterdictState.class));
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        return false;
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return 2.0f;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        return false;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return this.flyingTicks / 5 % 2 == --order / 6;
    }
}

