/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.BeingInterdictedState;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.InterdictingState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import dev.enjarai.minitardis.component.flight.SuspendedFlightState;
import dev.enjarai.minitardis.component.flight.TakingOffState;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FlyingState
implements FlightState {
    public static final MapCodec<FlyingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("errorLoops").forGetter(s -> s.errorLoops), (App)Codec.INT_STREAM.fieldOf("offsets").forGetter(s -> Arrays.stream(s.offsets)), (App)Codec.INT.fieldOf("scale_state").forGetter(s -> s.scaleState)).apply((Applicative)instance, FlyingState::new));
    public static final class_2960 ID = MiniTardis.id("flying");
    static final int SOUND_LOOP_LENGTH = 32;
    private static final int AFTERSHAKE_LENGTH = 80;
    private static final int WAVE_REFRESH_INTERVAL = 300;
    int flyingTicks;
    int aftershakeTicks;
    int completedTicks;
    public int errorLoops;
    public int[] offsets;
    public int scaleState;

    private FlyingState(int flyingTicks, int errorLoops, IntStream offsets, int scaleState) {
        this.flyingTicks = flyingTicks;
        this.errorLoops = errorLoops;
        this.offsets = offsets.toArray();
        this.scaleState = scaleState;
    }

    public FlyingState(int distance) {
        this.flyingTicks = 0;
        this.errorLoops = 0;
        this.offsets = new int[8];
        this.scaleState = 0;
        this.setOffsets(distance);
    }

    @Override
    public void init(Tardis tardis) {
        tardis.shuffleFlightWave();
    }

    @Override
    public FlightState tick(Tardis tardis) {
        ++this.flyingTicks;
        ++this.aftershakeTicks;
        if (this.flyingTicks % 32 == 0) {
            boolean isError;
            boolean bl = isError = this.errorLoops > 0;
            if (isError) {
                --this.errorLoops;
                float errorPitch = tardis.getInteriorWorld().method_8409().method_43057() - 0.5f;
                this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP_ERROR, class_3419.field_15245, 0.6f, errorPitch);
            }
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP, class_3419.field_15245, 0.6f, 1.0f);
        }
        if (this.getDistance() == 0) {
            ++this.completedTicks;
            if (this.completedTicks == 11) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 0.9f);
            } else if (this.completedTicks == 16) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 1.1f);
            }
        } else {
            this.completedTicks = 0;
        }
        if (tardis.getStability() <= 0) {
            return new SearchingForLandingState(true, tardis.getRandom().method_43054());
        }
        if (tardis.getControls().isDestinationLocked()) {
            this.scaleState = tardis.getControls().getScaleState();
        }
        if (this.flyingTicks % 10 == 0 && !tardis.addOrDrainFuel(-1)) {
            tardis.getControls().moderateMalfunction();
            return this;
        }
        return this;
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return Math.max((float)(80 - this.aftershakeTicks) / 80.0f, 0.0f);
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof SearchingForLandingState) {
            SearchingForLandingState landingState = (SearchingForLandingState)newState;
            if (!tardis.getDestination().map(destination -> tardis.getExteriorWorldKey().equals(destination.worldKey())).orElse(false).booleanValue()) {
                tardis.getControls().minorMalfunction();
                return false;
            }
            if (!landingState.crashing && !tardis.getControls().isDestinationLocked()) {
                tardis.getControls().moderateMalfunction();
                return false;
            }
            landingState.errorDistance = this.getDistance();
            landingState.flyingTicks = this.flyingTicks;
            return true;
        }
        if (newState instanceof DriftingState) {
            DriftingState driftingState = (DriftingState)newState;
            driftingState.flyingTicks = this.flyingTicks;
            return true;
        }
        if (newState instanceof InterdictingState) {
            InterdictingState interdictingState = (InterdictingState)newState;
            Optional<Tardis> other = tardis.getHolder().getTardis(interdictingState.otherTardis);
            if (other.map(o -> o.getState().canBeInterdicted((Tardis)o)).orElse(false).booleanValue()) {
                interdictingState.flyingTicks = this.flyingTicks;
                return true;
            }
            return false;
        }
        if (newState instanceof BeingInterdictedState) {
            BeingInterdictedState interceptedState = (BeingInterdictedState)newState;
            interceptedState.flyingTicks = this.flyingTicks;
            return true;
        }
        if (newState instanceof SuspendedFlightState) {
            SuspendedFlightState suspendedFlightState = (SuspendedFlightState)newState;
            suspendedFlightState.flyingTicks = this.flyingTicks;
            suspendedFlightState.distance = this.getDistance();
            return true;
        }
        if (newState instanceof TakingOffState) {
            return false;
        }
        tardis.getControls().minorMalfunction();
        return false;
    }

    public void setOffsets(int distance) {
        for (int i = 0; i < this.offsets.length; ++i) {
            int value = distance >> i * 2 & 3;
            this.offsets[i] = switch (value) {
                case 1 -> -1;
                case 2 -> 1;
                default -> 0;
            };
        }
    }

    public int getDistance() {
        int result = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int value = switch (this.offsets[i]) {
                case -1 -> 1;
                case 1 -> 2;
                default -> 0;
            };
            result |= value << i * 2;
        }
        return result;
    }

    public static int trimDistance(int distance) {
        int result = 0;
        for (int i = 0; i < 8; ++i) {
            int value = distance >> i * 2 & 3;
            if (value == 3) {
                value = 0;
            }
            result |= value << i * 2;
        }
        return result;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean canBeInterdicted(Tardis tardis) {
        return true;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return FlyingState.spinnyLighting(order, this.flyingTicks);
    }

    public static boolean spinnyLighting(int order, int flyingTicks) {
        if (order == 0) {
            return true;
        }
        int pointInCycle = flyingTicks / 5 % 12;
        int pointInCycleOffset = (flyingTicks / 5 + 4) % 12;
        return pointInCycle < pointInCycleOffset ? order % 12 >= pointInCycle && order % 12 < pointInCycleOffset : --order % 12 >= pointInCycle || order % 12 < pointInCycleOffset;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

