/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.flight.BeingInterdictedState;
import dev.enjarai.minitardis.component.flight.BootingUpState;
import dev.enjarai.minitardis.component.flight.CrashedState;
import dev.enjarai.minitardis.component.flight.CrashingState;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.InterdictingState;
import dev.enjarai.minitardis.component.flight.LandedState;
import dev.enjarai.minitardis.component.flight.LandingState;
import dev.enjarai.minitardis.component.flight.RefuelingState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import dev.enjarai.minitardis.component.flight.SuspendedFlightState;
import dev.enjarai.minitardis.component.flight.TakingOffState;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public interface FlightState {
    public static final Map<class_2960, MapCodec<? extends FlightState>> ALL = Map.ofEntries(Map.entry(LandedState.ID, LandedState.CODEC), Map.entry(TakingOffState.ID, TakingOffState.CODEC), Map.entry(FlyingState.ID, FlyingState.CODEC), Map.entry(LandingState.ID, LandingState.CODEC), Map.entry(SearchingForLandingState.ID, SearchingForLandingState.CODEC), Map.entry(CrashingState.ID, CrashingState.CODEC), Map.entry(RefuelingState.ID, RefuelingState.CODEC), Map.entry(DriftingState.ID, DriftingState.CODEC), Map.entry(DisabledState.ID, DisabledState.CODEC), Map.entry(BootingUpState.ID, BootingUpState.CODEC), Map.entry(CrashedState.ID, CrashedState.CODEC), Map.entry(SuspendedFlightState.ID, SuspendedFlightState.CODEC), Map.entry(InterdictingState.ID, InterdictingState.CODEC), Map.entry(BeingInterdictedState.ID, BeingInterdictedState.CODEC));
    public static final Map<class_2960, Supplier<? extends FlightState>> CONSTRUCTORS = Map.of(LandedState.ID, LandedState::new, RefuelingState.ID, RefuelingState::new, DriftingState.ID, DriftingState::new, DisabledState.ID, DisabledState::new, BootingUpState.ID, BootingUpState::new, CrashedState.ID, CrashedState::new, SuspendedFlightState.ID, SuspendedFlightState::new);
    public static final Codec<FlightState> CODEC = class_2960.field_25139.dispatch(FlightState::id, ALL::get);

    default public void init(Tardis tardis) {
    }

    public FlightState tick(Tardis var1);

    default public void complete(Tardis tardis) {
    }

    public boolean suggestTransition(Tardis var1, FlightState var2);

    default public boolean isSolid(Tardis tardis) {
        return true;
    }

    default public boolean tryChangeCourse(Tardis tardis) {
        return true;
    }

    default public boolean isPowered(Tardis tardis) {
        return true;
    }

    default public boolean overrideScreenImage(Tardis tardis) {
        return false;
    }

    default public boolean canBeInterdicted(Tardis tardis) {
        return false;
    }

    default public void drawScreenImage(TardisControl controls, DrawableCanvas canvas, ScreenBlockEntity blockEntity) {
    }

    default public float getScreenShakeIntensity(Tardis tardis) {
        return 0.0f;
    }

    public class_2960 id();

    default public class_2561 getName() {
        return class_2561.method_43471((String)("mini_tardis.state." + this.id().method_12836() + "." + this.id().method_12832()));
    }

    default public byte getExteriorAlpha(Tardis tardis) {
        return -1;
    }

    default public boolean isInteriorLightEnabled(int order) {
        return true;
    }

    default public void playForInterior(Tardis tardis, class_3414 soundEvent, class_3419 category, float volume, float pitch) {
        class_3218 world = tardis.getInteriorWorld();
        for (class_3222 player : world.method_18456()) {
            world.method_43129(null, (class_1297)player, soundEvent, category, volume, pitch);
        }
    }

    default public void playForInteriorAndExterior(Tardis tardis, class_3414 soundEvent, class_3419 category, float volume, float pitch) {
        this.playForInterior(tardis, soundEvent, category, volume, pitch);
        tardis.getExteriorWorld().ifPresent(world -> world.method_8396(null, tardis.getCurrentLandedLocation().get().pos(), soundEvent, category, volume, pitch));
    }

    default public void stopPlayingForInterior(Tardis tardis, class_3414 soundEvent) {
        class_2770 stopSoundS2CPacket = new class_2770(soundEvent.method_14833(), null);
        for (class_3222 player : tardis.getInteriorWorld().method_18456()) {
            player.field_13987.method_14364((class_2596)stopSoundS2CPacket);
        }
    }
}

