/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.RespondsToFlyLever;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class DriftingState
implements FlightState,
RespondsToFlyLever {
    public static final MapCodec<DriftingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("phase_count").forGetter(s -> s.phaseCount), (App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("phase_length").forGetter(s -> s.phaseLength), (App)Codec.INT.fieldOf("phase_ticks").forGetter(s -> s.phaseTicks), (App)Codec.INT.fieldOf("phases_complete").forGetter(s -> s.phasesComplete)).apply((Applicative)instance, DriftingState::new));
    public static final class_2960 ID = MiniTardis.id("drifting");
    private static final int TRANSITION_POINT = 40;
    public int phaseCount;
    int flyingTicks;
    public int phaseLength;
    public int phaseTicks;
    public int phasesComplete;

    DriftingState(int phaseCount, int flyingTicks, int phaseLength, int phaseTicks, int phasesComplete) {
        this.phaseCount = phaseCount;
        this.flyingTicks = flyingTicks;
        this.phaseLength = phaseLength;
        this.phaseTicks = phaseTicks;
        this.phasesComplete = phasesComplete;
    }

    public DriftingState() {
        this(0, 0, 0, 0, 0);
    }

    @Override
    public void init(Tardis tardis) {
        this.phaseCount = tardis.getRandom().method_39332(2, 3) * 2 - 1;
        this.phaseLength = tardis.getRandom().method_39332(20, 40);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        ++this.flyingTicks;
        ++this.phaseTicks;
        if (this.flyingTicks % 32 == 0) {
            float errorPitch = tardis.getInteriorWorld().method_8409().method_43057() - 0.5f;
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP_ERROR, class_3419.field_15245, 0.6f, errorPitch);
            this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP, class_3419.field_15245, 0.6f, 1.0f);
        }
        if (this.phasesComplete >= this.phaseCount) {
            if (this.phaseTicks == 11) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 0.9f);
            } else if (this.phaseTicks == 16) {
                this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 1.1f);
            } else if (this.phaseTicks >= 21) {
                tardis.getControls().setDestinationLocked(true, true);
                tardis.getDestination().ifPresent(destination -> tardis.setCurrentLocation(new PartialTardisLocation(destination.worldKey())));
                FlyingState flyingState = new FlyingState(tardis.getRandom().method_43054());
                flyingState.flyingTicks = this.flyingTicks;
                return flyingState;
            }
        }
        if (tardis.getStability() <= 0) {
            if (tardis.getControls().isDestinationLocked()) {
                tardis.getDestination().ifPresent(destination -> tardis.setCurrentLocation(new PartialTardisLocation(destination.worldKey())));
            }
            return new SearchingForLandingState(true, tardis.getRandom().method_43054());
        }
        tardis.addOrDrainFuel(1);
        tardis.destabilize(4);
        if (this.phaseTicks == this.phaseLength) {
            this.playForInterior(tardis, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
        }
        return this;
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return 2.0f;
    }

    @Override
    public boolean toggleFlyLever(Tardis tardis, boolean active) {
        if (this.phaseTicks >= this.phaseLength) {
            if (this.phasesComplete < this.phaseCount) {
                ++this.phasesComplete;
                this.phaseTicks = 0;
                this.phaseLength = tardis.getRandom().method_39332(5, 40);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        if (newState instanceof FlyingState) {
            FlyingState flyingState = (FlyingState)newState;
            flyingState.flyingTicks = this.flyingTicks;
            flyingState.errorLoops = 2;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        return false;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return this.flyingTicks / 5 % 2 == --order / 6;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

