/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.CrashedState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.TransitionalFlightState;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class CrashingState
extends TransitionalFlightState {
    public static final MapCodec<CrashingState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("ticks_passed").forGetter(s -> s.ticksPassed), (App)TardisLocation.CODEC.fieldOf("landing_destination").forGetter(s -> s.landingDestination)).apply((Applicative)instance, CrashingState::new));
    public static final class_2960 ID = MiniTardis.id("crashing");
    private final TardisLocation landingDestination;

    private CrashingState(int ticksPassed, TardisLocation landingDestination) {
        super(ticksPassed);
        this.landingDestination = landingDestination;
    }

    public CrashingState(TardisLocation landingDestination) {
        this(0, landingDestination);
    }

    @Override
    public void init(Tardis tardis) {
        tardis.setCurrentLocation(this.landingDestination);
        tardis.buildExterior();
    }

    @Override
    public FlightState tick(Tardis tardis) {
        if (tardis.getCurrentLandedLocation().map(tardis::canLandAt).orElse(false).booleanValue()) {
            tardis.getControls().moderateMalfunction();
            tardis.setCurrentLocation(new PartialTardisLocation(tardis.getExteriorWorldKey()));
            return new FlyingState(tardis.getRandom().method_43054());
        }
        if (this.ticksPassed < 160) {
            if (this.ticksPassed % 32 == 0) {
                this.playForInterior(tardis, ModSounds.TARDIS_FLY_LOOP_ERROR, class_3419.field_15245, 1.0f, tardis.getInteriorWorld().method_8409().method_43057() - 0.5f);
            }
        } else if (this.ticksPassed == 160) {
            this.playForInteriorAndExterior(tardis, ModSounds.TARDIS_CRASH_LAND, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (this.ticksPassed % 100 == 0) {
            this.playForInteriorAndExterior(tardis, ModSounds.CLOISTER_BELL, class_3419.field_15245, 1.0f, 1.0f);
        }
        return super.tick(tardis);
    }

    @Override
    public float getScreenShakeIntensity(Tardis tardis) {
        return 3.0f;
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        tardis.getControls().majorMalfunction();
        return false;
    }

    @Override
    public FlightState getNextState(Tardis tardis) {
        return new CrashedState();
    }

    @Override
    public int getTransitionDuration(Tardis tardis) {
        return 300;
    }

    @Override
    public boolean isSolid(Tardis tardis) {
        return false;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        tardis.getControls().majorMalfunction();
        return false;
    }

    @Override
    public byte getExteriorAlpha(Tardis tardis) {
        double vwoompWave = Math.sin((double)this.ticksPassed / 5.0) * 0.2 + 1.0;
        return (byte)((double)(this.ticksPassed / (this.getTransitionDuration(tardis) / 15)) * vwoompWave);
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return this.ticksPassed / 5 % 2 == 0;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

