/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class CrashedState
implements FlightState {
    public static final MapCodec<CrashedState> CODEC = MapCodec.unit(CrashedState::new);
    public static final class_2960 ID = MiniTardis.id("crashed");
    private int litLamps;

    @Override
    public FlightState tick(Tardis tardis) {
        if (tardis.getInteriorWorld().method_8510() % 100L == 0L) {
            this.playForInteriorAndExterior(tardis, ModSounds.CLOISTER_BELL, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (tardis.getInteriorWorld().method_8409().method_43048(20) == 0) {
            int size = tardis.getInteriorWorld().method_8409().method_43048(6);
            int shift = tardis.getInteriorWorld().method_8409().method_43048(24);
            this.litLamps = Integer.MAX_VALUE >> 32 - size << shift;
        }
        return this;
    }

    @Override
    public void init(Tardis tardis) {
        this.stopPlayingForInterior(tardis, ModSounds.CORAL_HUM);
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        return newState instanceof DisabledState;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return (this.litLamps & 1 << order) > 0;
    }

    @Override
    public boolean tryChangeCourse(Tardis tardis) {
        return false;
    }

    @Override
    public boolean isPowered(Tardis tardis) {
        return false;
    }

    @Override
    public boolean overrideScreenImage(Tardis tardis) {
        return true;
    }

    @Override
    public void drawScreenImage(TardisControl controls, DrawableCanvas canvas, ScreenBlockEntity blockEntity) {
        long cycle = controls.getTardis().getInteriorWorld().method_8510() / 20L % 2L;
        canvas.draw(0, 0, TardisCanvasUtils.getSprite("critical_failure_" + cycle));
        TardisCanvasUtils.drawCenteredText(canvas, "CRITICAL FAILURE", 64, 36, CanvasColors.RED);
        TardisCanvasUtils.drawCenteredText(canvas, "Reset power coupling", 64, 46, CanvasColors.RED_DULL);
        TardisCanvasUtils.drawCenteredText(canvas, "for system reboot", 64, 54, CanvasColors.RED_DULL);
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

