/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.console.ScreenBlockEntity;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.LandedState;
import dev.enjarai.minitardis.component.flight.TransitionalFlightState;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BootingUpState
extends TransitionalFlightState {
    public static final MapCodec<BootingUpState> CODEC = Codec.INT.xmap(BootingUpState::new, s -> s.ticksPassed).fieldOf("ticks_passed");
    public static final class_2960 ID = MiniTardis.id("booting_up");
    private final List<Line> consoleLogs = new ArrayList<Line>();

    private BootingUpState(int ticksPassed) {
        super(ticksPassed);
    }

    public BootingUpState() {
        this(0);
    }

    @Override
    public void complete(Tardis tardis) {
        this.playForInterior(tardis, class_3417.field_23118, class_3419.field_15245, 2.0f, 0.0f);
        this.playForInterior(tardis, class_3417.field_14703, class_3419.field_15245, 2.0f, 0.0f);
        this.playForInterior(tardis, ModSounds.CORAL_HUM, class_3419.field_15256, 0.3f, 1.0f);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        if (this.ticksPassed % 15 == 0) {
            this.playForInterior(tardis, class_3417.field_23116, class_3419.field_15245, 1.0f, (float)this.ticksPassed / 100.0f);
        }
        this.writeLineForTick();
        return super.tick(tardis);
    }

    @Override
    public boolean suggestTransition(Tardis tardis, FlightState newState) {
        return false;
    }

    @Override
    public FlightState getNextState(Tardis tardis) {
        return new LandedState();
    }

    @Override
    public int getTransitionDuration(Tardis tardis) {
        return 180;
    }

    @Override
    public boolean isInteriorLightEnabled(int order) {
        return order <= this.ticksPassed / 15;
    }

    @Override
    public boolean isPowered(Tardis tardis) {
        return false;
    }

    @Override
    public boolean overrideScreenImage(Tardis tardis) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawScreenImage(TardisControl controls, DrawableCanvas canvas, ScreenBlockEntity blockEntity) {
        List<Line> logs;
        canvas.fillRaw(0, 0, 128, 96, CanvasColors.BLACK);
        List<Line> list = this.consoleLogs;
        synchronized (list) {
            logs = List.copyOf(this.consoleLogs);
        }
        List<Line> subList = logs.subList(Math.max(0, this.consoleLogs.size() - 10), this.consoleLogs.size());
        for (int i = 0; i < subList.size(); ++i) {
            Line line = subList.get(i);
            int y = 2 + i * 9;
            DefaultFonts.VANILLA.drawText(canvas, line.line(), 2, y, 8.0, CanvasColors.WHITE);
            if (!line.loads()) continue;
            int width = DefaultFonts.VANILLA.getTextWidth(line.line(), 8.0);
            if (i == subList.size() - 1) {
                DefaultFonts.VANILLA.drawText(canvas, this.getSpinnyThing(controls.getTardis().getInteriorWorld().method_8510()), width + 6, y, 8.0, CanvasColors.ORANGE);
                continue;
            }
            DefaultFonts.VANILLA.drawText(canvas, "Done", width + 6, y, 8.0, CanvasColors.LIME);
        }
    }

    private String getSpinnyThing(long tick) {
        return switch ((int)(tick / 4L % 4L)) {
            case 0 -> "-";
            case 1 -> "\\";
            case 2 -> "|";
            case 3 -> "/";
            default -> throw new IllegalStateException("Unexpected value: " + tick / 4L % 4L);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLineForTick() {
        Line line;
        switch (this.ticksPassed) {
            case 1: {
                Line line2 = new Line(" ___       __ ", false);
                break;
            }
            case 2: {
                Line line2 = new Line("  | | \\  _  (_  ", false);
                break;
            }
            case 3: {
                Line line2 = new Line("  | |_/ (_) __) ", false);
                break;
            }
            case 4: {
                Line line2 = new Line("Preparing...", true);
                break;
            }
            case 20: {
                Line line2 = new Line("Connecting artron banks...", true);
                break;
            }
            case 25: {
                Line line2 = new Line("Calculating offsets...", true);
                break;
            }
            case 36: {
                Line line2 = new Line("Initializing GTPS...", true);
                break;
            }
            case 43: {
                Line line2 = new Line("Locating dimensions...", true);
                break;
            }
            case 60: {
                Line line2 = new Line("Running diagnostics...", true);
                break;
            }
            case 85: {
                Line line2 = new Line("No problems found.", false);
                break;
            }
            case 89: {
                Line line2 = new Line("Core systems ready!", false);
                break;
            }
            case 90: {
                Line line2 = new Line("Connecting conduits...", true);
                break;
            }
            case 100: {
                Line line2 = new Line("Spinning up...", true);
                break;
            }
            case 120: {
                Line line2 = new Line("Compensating...", true);
                break;
            }
            case 129: {
                Line line2 = new Line("Time rotor ready!", false);
                break;
            }
            case 130: {
                Line line2 = new Line("Starting main OS...", true);
                break;
            }
            case 140: {
                Line line2 = new Line("Loading packager...", true);
                break;
            }
            case 146: {
                Line line2 = new Line("Loading waypoints...", true);
                break;
            }
            case 154: {
                Line line2 = new Line("Loading history...", true);
                break;
            }
            case 159: {
                Line line2 = new Line("OS ready!", false);
                break;
            }
            case 160: {
                Line line2 = new Line("Done!", false);
                break;
            }
            default: {
                Line line2 = line = null;
            }
        }
        if (line != null) {
            List<Line> list = this.consoleLogs;
            synchronized (list) {
                this.consoleLogs.add(line);
            }
        }
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    private record Line(String line, boolean loads) {
    }
}

