/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.InterdictState;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4844;

public class BeingInterdictedState
extends InterdictState {
    public static final MapCodec<BeingInterdictedState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4844.field_40825.fieldOf("other_tardis").forGetter(s -> s.otherTardis), (App)Codec.INT.fieldOf("flying_ticks").forGetter(s -> s.flyingTicks), (App)Codec.INT.fieldOf("phases_complete").forGetter(s -> s.phasesComplete), (App)Codec.INT.fieldOf("phase_ticks").forGetter(s -> s.phaseTicks), (App)Codec.INT.fieldOf("offset_x").forGetter(s -> s.offsetX), (App)Codec.INT.fieldOf("offset_y").forGetter(s -> s.offsetY), (App)Codec.INT.fieldOf("target_x").forGetter(s -> s.targetX), (App)Codec.INT.fieldOf("target_y").forGetter(s -> s.targetY)).apply((Applicative)instance, BeingInterdictedState::new));
    public static final class_2960 ID = MiniTardis.id("being_interdicted");
    private int targetX;
    private int targetY;

    protected BeingInterdictedState(UUID otherTardis, int flyingTicks, int phasesComplete, int phaseTicks, int offsetX, int offsetY, int targetX, int targetY) {
        super(otherTardis, flyingTicks, phasesComplete, phaseTicks, offsetX, offsetY);
        this.targetX = targetX;
        this.targetY = targetY;
    }

    public BeingInterdictedState(UUID otherTardis) {
        super(otherTardis);
    }

    public void shuffleTarget(Tardis tardis) {
        this.targetX = tardis.getRandom().method_39332(-4, 4);
        this.targetY = tardis.getRandom().method_39332(-2, 2);
    }

    @Override
    public void init(Tardis tardis) {
        this.shuffleTarget(tardis);
        tardis.setSparksQueued(5);
        super.init(tardis);
    }

    @Override
    public FlightState tick(Tardis tardis) {
        Optional<Tardis> other;
        if (this.flyingTicks % 100 == 0) {
            this.playForInterior(tardis, ModSounds.CLOISTER_BELL, class_3419.field_15245, 1.0f, 1.0f);
        }
        if ((other = tardis.getHolder().getTardis(this.otherTardis)).flatMap(t -> t.getState(InterdictState.class)).isEmpty()) {
            tardis.getControls().moderateMalfunction();
            return new FlyingState(tardis.getRandom().method_43054());
        }
        return super.tick(tardis);
    }

    @Override
    protected FlightState completeMinigame(Tardis tardis) {
        Optional<Tardis> other = tardis.getHolder().getTardis(this.otherTardis);
        other.ifPresent(t -> t.suggestStateTransition(new SearchingForLandingState(true, t.getRandom().method_43054())));
        FlyingState newState = new FlyingState(tardis.getRandom().method_43054());
        newState.flyingTicks = this.flyingTicks;
        return newState;
    }

    @Override
    protected void completePhase(Tardis tardis) {
        if (this.phasesComplete < 6) {
            this.shuffleTarget(tardis);
        }
        super.completePhase(tardis);
    }

    @Override
    public int getTargetX() {
        return this.targetX;
    }

    @Override
    public int getTargetY() {
        return this.targetY;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

