/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.Tardis;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;
import xyz.nucleoid.fantasy.Fantasy;

public class TardisHolder
implements ServerTickingComponent {
    private MinecraftServer server;
    private Fantasy fantasy;
    private Map<UUID, Tardis> tardii = new HashMap<UUID, Tardis>();

    private void loadServer() {
        this.server = MiniTardis.getServer();
        if (this.server == null) {
            throw new IllegalStateException("Interacted with Tardis properties too early, wait for server to initialize.");
        }
        this.fantasy = Fantasy.get((MinecraftServer)this.server);
    }

    public MinecraftServer getServer() {
        if (this.server == null) {
            this.loadServer();
        }
        return this.server;
    }

    public Fantasy getFantasy() {
        if (this.fantasy == null) {
            this.loadServer();
        }
        return this.fantasy;
    }

    public void addTardis(Tardis tardis) {
        tardis.holder = this;
        this.tardii.put(tardis.uuid(), tardis);
    }

    public Optional<Tardis> getTardis(UUID uuid) {
        return Optional.ofNullable(this.tardii.get(uuid));
    }

    public Set<Tardis> getAllTardii() {
        return ImmutableSet.copyOf(this.tardii.values());
    }

    public Set<Tardis> getInterdictableTardii() {
        return this.tardii.values().stream().filter(t -> t.getState().canBeInterdicted((Tardis)t)).collect(Collectors.toSet());
    }

    public void serverTick() {
        this.tardii.values().forEach(Tardis::tick);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.tardii = new HashMap<UUID, Tardis>();
        tag.method_10554("tardii", 10).stream().map(el -> (Tardis)((Pair)Tardis.CODEC.decode((DynamicOps)class_2509.field_11560, el).getOrThrow(s -> {
            throw new IllegalArgumentException((String)s);
        })).getFirst()).forEach(this::addTardis);
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10566("tardii", (class_2520)class_156.method_654((Object)new class_2499(), li -> this.tardii.values().stream().map(el -> (class_2520)Tardis.CODEC.encodeStart((DynamicOps)class_2509.field_11560, el).getOrThrow(s -> {
            throw new IllegalArgumentException((String)s);
        })).forEach(arg_0 -> li.add(arg_0))));
    }
}

