/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.BootingUpState;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.InterdictingState;
import dev.enjarai.minitardis.component.flight.LandedState;
import dev.enjarai.minitardis.component.flight.RefuelingState;
import dev.enjarai.minitardis.component.flight.RespondsToFlyLever;
import dev.enjarai.minitardis.component.flight.RespondsToNudging;
import dev.enjarai.minitardis.component.flight.SearchingForLandingState;
import dev.enjarai.minitardis.component.flight.SuspendedFlightState;
import dev.enjarai.minitardis.component.flight.TakingOffState;
import dev.enjarai.minitardis.component.screen.app.GpsApp;
import dev.enjarai.minitardis.component.screen.app.HistoryApp;
import dev.enjarai.minitardis.component.screen.app.PackageManagerApp;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.app.StatusApp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class TardisControl {
    public static final Codec<TardisControl> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("coordinate_scale").forGetter(c -> c.coordinateScale), (App)ScreenApp.CODEC.listOf().fieldOf("screen_apps").forGetter(c -> ImmutableList.copyOf(c.screenApps.values())), (App)Codec.BOOL.optionalFieldOf("destination_locked", (Object)false).forGetter(c -> c.destinationLocked), (App)Codec.BOOL.optionalFieldOf("energy_conduits_unlocked", (Object)false).forGetter(c -> c.energyConduitsUnlocked)).apply((Applicative)instance, TardisControl::new));
    private int coordinateScale;
    private final Map<ScreenAppType<?>, ScreenApp> screenApps;
    private boolean destinationLocked;
    private boolean energyConduitsUnlocked;
    Tardis tardis;

    private TardisControl(int coordinateScale, Collection<ScreenApp> screenApps, boolean destinationLocked, boolean energyConduitsUnlocked) {
        this.coordinateScale = coordinateScale;
        this.screenApps = new HashMap();
        screenApps.forEach(app -> this.screenApps.put(app.getType(), (ScreenApp)app));
        this.destinationLocked = destinationLocked;
        this.energyConduitsUnlocked = energyConduitsUnlocked;
    }

    public TardisControl(TardisControl copyFrom) {
        this(copyFrom.coordinateScale, copyFrom.screenApps.values(), copyFrom.destinationLocked, copyFrom.energyConduitsUnlocked);
    }

    public TardisControl() {
        this(1, List.of(new PackageManagerApp(), new StatusApp(), new GpsApp(), new HistoryApp()), false, false);
    }

    public boolean resetDestination() {
        if (this.tardis.getCurrentLandedLocation().isEmpty()) {
            this.tardis.shuffleFlightWave();
            return false;
        }
        boolean success = this.tardis.setDestination(this.tardis.getCurrentLandedLocation(), false);
        if (success) {
            this.destinationLocked = false;
        }
        return success;
    }

    public boolean updateCoordinateScale(int scale) {
        this.coordinateScale = scale;
        return true;
    }

    public int getScaleState() {
        return (int)Math.log10(this.coordinateScale);
    }

    public boolean nudgeDestination(class_2350 direction) {
        boolean success;
        if (!direction.method_10166().method_10178()) {
            FlightState flightState = this.tardis.getState();
            Objects.requireNonNull(flightState);
            FlightState flightState2 = flightState;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FlyingState.class, RespondsToNudging.class}, (Object)flightState2, n)) {
                case 0: {
                    FlyingState state = (FlyingState)flightState2;
                    if (!this.isDestinationLocked()) break;
                    int axis = direction.method_10166().ordinal() == 0 ? 1 : 0;
                    int i = state.scaleState * 2 + axis;
                    int original = state.offsets[i];
                    state.offsets[i] = class_3532.method_15340((int)(original - direction.method_10171().method_10181()), (int)-1, (int)1);
                    return true;
                }
                case 1: {
                    RespondsToNudging state = (RespondsToNudging)((Object)flightState2);
                    return state.nudgeDestination(this.getTardis(), direction);
                }
            }
        }
        boolean bl = success = this.tardis.setDestination(this.tardis.getDestination().map(d -> {
            if (direction.method_10166().method_10178()) {
                return this.snapLocationVertically((TardisLocation)d, direction);
            }
            return d.with(d.pos().method_10081(direction.method_10163().method_35862(this.coordinateScale)));
        }), false) && this.tardis.getDestination().isPresent();
        if (success) {
            this.destinationLocked = false;
        }
        return success;
    }

    private TardisLocation snapLocationVertically(TardisLocation location, class_2350 direction) {
        Optional<class_3218> world = this.tardis.getDestinationWorld();
        if (world.isPresent()) {
            if (!world.get().method_24794(location.pos())) {
                location = location.with(location.pos().method_33096(class_3532.method_15340((int)location.pos().method_10264(), (int)world.get().method_31607(), (int)world.get().method_31600())));
            }
            class_2338 pos = location.pos().method_10093(direction);
            while (world.get().method_24794(pos)) {
                TardisLocation checkLocation = location.with(pos);
                if (this.tardis.canSnapDestinationTo(checkLocation)) {
                    return checkLocation;
                }
                pos = pos.method_10093(direction);
            }
        }
        return location;
    }

    public boolean rotateDestination(class_2350 direction) {
        boolean success;
        boolean bl = success = this.tardis.setDestination(this.tardis.getDestination().map(d -> d.with(direction)), false) && this.tardis.getDestination().isPresent();
        if (success) {
            this.destinationLocked = false;
        }
        return success;
    }

    public boolean handbrake(boolean state) {
        if (!state && this.tardis.getState() instanceof FlyingState && !this.isDestinationLocked()) {
            return this.tardis.getDestinationTardis().map(otherTardis -> this.tardis.suggestStateTransition(new InterdictingState(otherTardis.uuid()))).orElseGet(() -> this.tardis.suggestStateTransition(new DriftingState()));
        }
        FlightState flightState = this.tardis.getState();
        if (flightState instanceof RespondsToFlyLever) {
            RespondsToFlyLever respondingState = (RespondsToFlyLever)((Object)flightState);
            return respondingState.toggleFlyLever(this.tardis, state) || this.tardis.suggestStateTransition(new FlyingState(this.tardis.getRandom().method_43054()));
        }
        if (this.tardis.isDoorOpen()) {
            return false;
        }
        return this.tardis.suggestStateTransition(state ? new TakingOffState() : new SearchingForLandingState(false, 0));
    }

    public boolean isDestinationLocked() {
        return this.destinationLocked;
    }

    public boolean setDestinationLocked(boolean destinationLocked, boolean force) {
        if (force || this.tardis.getState().tryChangeCourse(this.tardis)) {
            this.destinationLocked = destinationLocked;
            return true;
        }
        return false;
    }

    public boolean areEnergyConduitsUnlocked() {
        return this.energyConduitsUnlocked;
    }

    public boolean setEnergyConduits(boolean unlocked) {
        if (!this.tardis.getState().isSolid(this.tardis)) {
            if (!unlocked && this.tardis.getState(FlyingState.class).isPresent()) {
                this.tardis.suggestStateTransition(new SuspendedFlightState());
            } else if (unlocked && this.tardis.getState(SuspendedFlightState.class).isPresent()) {
                this.tardis.suggestStateTransition(new FlyingState(this.tardis.getState(SuspendedFlightState.class).get().distance));
            } else if (!unlocked) {
                this.majorMalfunction();
                return false;
            }
        } else if (unlocked && this.tardis.getState() instanceof RefuelingState) {
            return false;
        }
        this.energyConduitsUnlocked = unlocked;
        return true;
    }

    public boolean refuelToggle(boolean state) {
        return this.tardis.suggestStateTransition(state ? new RefuelingState() : new LandedState());
    }

    public boolean moveDestinationToDimension(class_5321<class_1937> worldKey) {
        boolean success;
        boolean bl = success = this.tardis.setDestination(this.tardis.getDestination().map(l -> l.with(worldKey)), false) && this.tardis.getDestination().isPresent();
        if (success) {
            this.destinationLocked = false;
        }
        return success;
    }

    public boolean toggleDisabledState() {
        return this.tardis.suggestStateTransition(this.tardis.getState() instanceof DisabledState ? new BootingUpState() : new DisabledState());
    }

    public void minorMalfunction() {
        this.tardis.destabilize(10);
    }

    public void moderateMalfunction() {
        this.tardis.destabilize(200);
    }

    public void majorMalfunction() {
        this.tardis.destabilize(1000);
    }

    public Tardis getTardis() {
        return this.tardis;
    }

    public Optional<ScreenApp> getScreenApp(@Nullable ScreenAppType<?> type) {
        return Optional.ofNullable(this.screenApps.get(type));
    }

    public List<ScreenApp> getAllApps() {
        return this.screenApps.values().stream().sorted(Comparator.comparing(ScreenApp::getId)).toList();
    }

    public boolean canUninstallApp(ScreenAppType<?> type) {
        return this.screenApps.containsKey(type) && this.screenApps.get(type).canBeUninstalled();
    }

    public Optional<ScreenApp> uninstallApp(ScreenAppType<?> type) {
        return Optional.ofNullable(this.screenApps.remove(type));
    }

    public boolean canInstallApp(ScreenApp app) {
        return !this.screenApps.containsKey(app.getType());
    }

    public boolean installApp(ScreenApp app) {
        if (!this.screenApps.containsKey(app.getType()) && this.screenApps.size() < 12) {
            this.screenApps.put(app.getType(), app);
            return true;
        }
        return false;
    }
}

