/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.ModCCAComponents;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.InteriorDoorBlock;
import dev.enjarai.minitardis.block.ModBlocks;
import dev.enjarai.minitardis.block.TardisExteriorBlock;
import dev.enjarai.minitardis.block.TardisExteriorBlockEntity;
import dev.enjarai.minitardis.component.DestinationScanner;
import dev.enjarai.minitardis.component.FlightWave;
import dev.enjarai.minitardis.component.HistoryEntry;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.ScreenShakeComponent;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.TardisHolder;
import dev.enjarai.minitardis.component.TardisInterior;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.TardisReference;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.flight.LandedState;
import dev.enjarai.minitardis.component.flight.LandingState;
import dev.enjarai.minitardis.component.screen.app.HistoryApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3229;
import net.minecraft.class_3230;
import net.minecraft.class_3232;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;

public class Tardis {
    public static final class_2960 DEFAULT_INTERIOR = MiniTardis.id("wooden_coral");
    public static final class_2338 INTERIOR_CENTER = new class_2338(0, 64, 0);
    public static final class_3230<class_2338> INTERIOR_TICKET_TYPE = class_3230.method_20628((String)"tardis_interior", class_2382::method_10265, (int)20);
    public static final Codec<Tardis> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("uuid").forGetter(t -> t.uuid), (App)Codec.BOOL.optionalFieldOf("interior_placed", (Object)false).forGetter(t -> t.interiorPlaced), (App)class_2960.field_25139.optionalFieldOf("interior", (Object)DEFAULT_INTERIOR).forGetter(t -> t.interior), (App)Codec.either(TardisLocation.CODEC, PartialTardisLocation.CODEC).fieldOf("current_location").forGetter(t -> t.currentLocation), (App)TardisLocation.CODEC.optionalFieldOf("destination").forGetter(t -> t.destination), (App)class_2338.field_25064.optionalFieldOf("interior_door_position", (Object)class_2338.field_10980).forGetter(t -> t.interiorDoorPosition), (App)TardisControl.CODEC.optionalFieldOf("controls", (Object)new TardisControl()).forGetter(t -> t.controls), (App)FlightState.CODEC.optionalFieldOf("flight_state", (Object)new LandedState()).forGetter(t -> t.state), (App)Codec.INT.optionalFieldOf("stability", (Object)1000).forGetter(t -> t.stability), (App)Codec.INT.optionalFieldOf("fuel", (Object)500).forGetter(t -> t.fuel), (App)Codec.BOOL.optionalFieldOf("door_open", (Object)false).forGetter(t -> t.doorOpen)).apply((Applicative)instance, Tardis::new));
    TardisHolder holder;
    @Nullable
    RuntimeWorldHandle interiorWorld;
    DestinationScanner destinationScanner = new DestinationScanner(this, 128);
    private int sparksQueued;
    private final UUID uuid;
    private boolean interiorPlaced;
    private class_2960 interior;
    private Either<TardisLocation, PartialTardisLocation> currentLocation;
    private Optional<TardisLocation> destination;
    private class_2338 interiorDoorPosition;
    private final TardisControl controls;
    private FlightState state;
    private int stability;
    private int fuel;
    private boolean doorOpen;
    private FlightWave flightWave;

    private Tardis(UUID uuid, boolean interiorPlaced, class_2960 interior, Either<TardisLocation, PartialTardisLocation> currentLocation, Optional<TardisLocation> destination, class_2338 interiorDoorPosition, TardisControl controls, FlightState state, int stability, int fuel, boolean doorOpen) {
        this.uuid = uuid;
        this.interiorPlaced = interiorPlaced;
        this.interior = interior;
        this.currentLocation = currentLocation;
        this.destination = destination;
        this.interiorDoorPosition = interiorDoorPosition;
        this.controls = new TardisControl(controls);
        this.state = state;
        this.stability = stability;
        this.fuel = fuel;
        this.doorOpen = doorOpen;
        this.controls.tardis = this;
    }

    public Tardis(TardisHolder holder, @Nullable TardisLocation location, class_2960 interior) {
        this(UUID.randomUUID(), false, interior, (Either<TardisLocation, PartialTardisLocation>)(location == null ? Either.right((Object)new PartialTardisLocation((class_5321<class_1937>)holder.getServer().method_30002().method_27983())) : Either.left((Object)location)), Optional.ofNullable(location), class_2338.field_10980, new TardisControl(), location == null ? new DisabledState() : new LandingState(location, true), 1000, 500, false);
        holder.addTardis(this);
        this.state.init(this);
        this.buildExterior();
        this.getInteriorWorld();
    }

    public Tardis(TardisHolder holder, TardisLocation destination) {
        this(UUID.randomUUID(), false, DEFAULT_INTERIOR, (Either<TardisLocation, PartialTardisLocation>)Either.right((Object)new PartialTardisLocation(destination.worldKey())), Optional.of(destination), class_2338.field_10980, new TardisControl(), new FlyingState(holder.getServer().method_30002().method_8409().method_43054()), 842, 567, false);
        holder.addTardis(this);
        this.state.init(this);
        this.getInteriorWorld();
        this.controls.setEnergyConduits(true);
    }

    public void tick() {
        boolean powered;
        float shake;
        class_3218 world = this.getInteriorWorld();
        if (world.method_8510() % 20L == 0L) {
            world.method_14178().method_17297(INTERIOR_TICKET_TYPE, new class_1923(this.interiorDoorPosition), 1, (Object)this.interiorDoorPosition);
        }
        if (this.flightWave == null) {
            this.flightWave = new FlightWave(this.getRandom());
        }
        FlightState newState = this.state.tick(this);
        this.applyScreenShake(shake, (shake = this.state.getScreenShakeIntensity(this)) > 0.0f ? 1.0f : 0.0f);
        if (newState != this.state) {
            this.state.complete(this);
            this.state = newState;
            newState.init(this);
        }
        if ((powered = this.state.isPowered(this)) && world.method_8510() % 240L == 0L) {
            this.state.playForInterior(this, ModSounds.CORAL_HUM, class_3419.field_15256, 0.3f, 1.0f);
        }
        if (powered) {
            this.getControls().getAllApps().forEach(app -> app.tardisTick(this));
        }
        if (this.sparksQueued > 0 && powered && world.method_8409().method_39332(0, 20) == 0) {
            this.createInteriorSparks(false);
            --this.sparksQueued;
        }
        if (this.stability < 200 && world.method_8409().method_39332(0, 20000) < 800 - this.stability * 4 && this.sparksQueued < 5) {
            ++this.sparksQueued;
        }
        if (!this.state.isSolid(this)) {
            this.setDoorOpen(false, true);
        }
        this.destinationScanner.tick();
    }

    private void applyScreenShake(float intensity, float speed) {
        class_3218 world = this.getInteriorWorld();
        for (class_3222 player : world.method_18456()) {
            ((ScreenShakeComponent)ModCCAComponents.SCREEN_SHAKE.get((Object)player)).setShake(intensity, speed);
        }
    }

    public class_3218 getInteriorWorld() {
        if (this.interiorWorld == null) {
            this.initializeInteriorWorld();
        }
        return this.interiorWorld.asWorld();
    }

    public Optional<class_3218> getExteriorWorld() {
        return Optional.of((class_3218)this.currentLocation.map(l -> l.getWorld(this.holder.getServer()), p -> p.getWorld(this.holder.getServer())));
    }

    public class_5321<class_1937> getExteriorWorldKey() {
        return (class_5321)this.currentLocation.map(TardisLocation::worldKey, PartialTardisLocation::worldKey);
    }

    public Optional<class_3218> getDestinationWorld() {
        return this.destination.map(l -> l.getWorld(this.holder.getServer()));
    }

    public Optional<Tardis> getDestinationTardis() {
        return this.getDestinationWorld().flatMap(w -> ((TardisReference)w.getComponent(ModCCAComponents.TARDIS_REFERENCE)).getTardis());
    }

    public DestinationScanner getDestinationScanner() {
        return this.destinationScanner;
    }

    private void initializeInteriorWorld() {
        MinecraftServer server = this.holder.getServer();
        class_2378 dimensionRegistry = server.method_30611().method_30530(class_7924.field_41241);
        class_6880.class_6883 voidBiome = (class_6880.class_6883)server.method_30611().method_30530(class_7924.field_41236).method_40264(class_1972.field_9473).orElseThrow();
        class_2897 chunkGenerator = new class_2897(new class_3232(Optional.empty(), (class_6880)voidBiome, List.of()).method_46727(List.of(new class_3229(256, (class_2248)ModBlocks.TARDIS_PLATING)), Optional.empty(), (class_6880)voidBiome));
        RuntimeWorldConfig config = new RuntimeWorldConfig().setDimensionType((class_6880)dimensionRegistry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)MiniTardis.id("tardis_interior")))).setGenerator((class_2794)chunkGenerator).setGameRule(class_1928.field_19396, false).setSeed(1234L);
        this.interiorWorld = this.holder.getFantasy().getOrOpenPersistentWorld(MiniTardis.id("tardis/" + this.uuid.toString()), config);
        this.interiorWorld.setTickWhenEmpty(false);
        ((TardisReference)this.interiorWorld.asWorld().getComponent(ModCCAComponents.TARDIS_REFERENCE)).tardis = this;
        if (!this.interiorPlaced) {
            this.buildInterior();
        }
    }

    private void buildInterior() {
        this.getInterior().ifPresentOrElse(interior -> {
            class_3499 structure = interior.getStructure(this.holder.getServer().method_27727());
            class_3218 world = this.getInteriorWorld();
            class_2382 size = structure.method_15160();
            class_2382 centerOffset = interior.templateCenter();
            class_2338 placementPos = centerOffset.equals((Object)class_2382.field_11176) ? INTERIOR_CENTER.method_10069(-size.method_10263() / 2, 0, -size.method_10260() / 2) : INTERIOR_CENTER.method_10081(centerOffset.method_35862(-1));
            structure.method_15172((class_5425)world, placementPos, class_2338.field_10980, new class_3492(), world.method_8409(), 2);
            this.interiorPlaced = true;
        }, () -> MiniTardis.LOGGER.info("Couldn't build interior."));
    }

    public void buildExterior() {
        this.currentLocation.ifLeft(location -> {
            class_3218 world = location.getWorld(this.holder.getServer());
            class_2338 pos = location.pos();
            world.method_8501(pos, (class_2680)ModBlocks.TARDIS_EXTERIOR.method_9564().method_11657((class_2769)TardisExteriorBlock.FACING, (Comparable)location.facing()));
            class_2586 patt0$temp = world.method_8321(pos);
            if (patt0$temp instanceof TardisExteriorBlockEntity) {
                TardisExteriorBlockEntity tardisExteriorBlockEntity = (TardisExteriorBlockEntity)patt0$temp;
                tardisExteriorBlockEntity.linkTardis(this);
            }
        });
    }

    public void teleportEntityIn(class_1297 entity) {
        if (this.state.isSolid(this)) {
            class_3218 world = this.getInteriorWorld();
            class_2338 targetPos = this.interiorDoorPosition;
            class_2680 interiorDoorState = world.method_8320(targetPos);
            float yaw = -90.0f;
            do {
                if (!interiorDoorState.method_27852((class_2248)ModBlocks.INTERIOR_DOOR) || interiorDoorState.method_11654(InteriorDoorBlock.HALF) != class_2756.field_12607) continue;
                class_2350 facing = (class_2350)interiorDoorState.method_11654((class_2769)class_2383.field_11177);
                this.interiorDoorPosition = targetPos;
                targetPos = targetPos.method_10081(facing.method_10163());
                yaw = facing.method_10144();
                break;
            } while ((interiorDoorState = world.method_8320(targetPos = world.method_19494().method_22383(poi -> ((class_4158)poi.comp_349()).equals((Object)ModBlocks.INTERIOR_DOOR_POI), this.interiorDoorPosition, 64, class_4153.class_4155.field_18489).findAny().map(class_4156::method_19141).orElse(this.interiorDoorPosition))).method_27852((class_2248)ModBlocks.INTERIOR_DOOR));
            class_243 entityPos = class_243.method_24955((class_2382)targetPos);
            entity.method_48105(world, entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), Set.of(), yaw, 0.0f);
            if (!(this.state instanceof DisabledState) && entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                world.method_43129(null, (class_1297)player, ModSounds.CORAL_HUM, class_3419.field_15256, 0.3f, 1.0f);
            }
        }
    }

    public void teleportEntityOut(class_1297 entity, class_2338 doorPos) {
        if (this.state.isSolid(this)) {
            this.currentLocation.ifLeft(location -> {
                TardisExteriorBlockEntity exteriorEntity;
                class_2338 pos;
                class_3218 world = location.getWorld(this.holder.getServer());
                class_2586 blockEntity = world.method_8321(pos = location.pos());
                if (!(blockEntity instanceof TardisExteriorBlockEntity) || !this.equals((exteriorEntity = (TardisExteriorBlockEntity)blockEntity).getLinkedTardis())) {
                    this.buildExterior();
                    blockEntity = world.method_8321(pos);
                }
                this.interiorDoorPosition = doorPos;
                if (blockEntity instanceof TardisExteriorBlockEntity && this.equals((exteriorEntity = (TardisExteriorBlockEntity)blockEntity).getLinkedTardis())) {
                    class_2350 facing = (class_2350)exteriorEntity.method_11010().method_11654((class_2769)TardisExteriorBlock.FACING);
                    class_2338 exitPos = pos.method_10081(facing.method_10163());
                    class_243 entityPos = class_243.method_24955((class_2382)exitPos);
                    entity.method_48105(world, entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), Set.of(), facing.method_10144(), 0.0f);
                    if (entity instanceof class_1657) {
                        class_1657 player = (class_1657)entity;
                        ((ScreenShakeComponent)ModCCAComponents.SCREEN_SHAKE.get((Object)player)).setShake(0.0f, 0.0f);
                    }
                }
            });
        }
    }

    public boolean canLandAt(TardisLocation location) {
        class_2338 pos;
        class_3218 world = location.getWorld(this.holder.getServer());
        if (!world.method_24794(pos = location.pos())) {
            return false;
        }
        class_2350 facing = location.facing();
        return world.method_8320(pos).method_45474() && (world.method_8316(pos).method_15769() || world.method_8316(pos).method_39360((class_3611)class_3612.field_15910)) && world.method_8320(pos.method_10084()).method_45474() && world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos, class_2350.field_11036) && world.method_8320(pos.method_10093(facing)).method_26220((class_1922)world, pos).method_1110() && world.method_8320(pos.method_10084().method_10093(facing)).method_26220((class_1922)world, pos).method_1110() && world.method_8320(pos.method_10074().method_10093(facing)).method_26206((class_1922)world, pos, class_2350.field_11036);
    }

    public boolean canSnapDestinationTo(TardisLocation location) {
        class_2338 pos;
        class_3218 world = location.getWorld(this.holder.getServer());
        if (!world.method_24794(pos = location.pos())) {
            return false;
        }
        class_2680 bottomState = world.method_8320(pos);
        if (!bottomState.method_45474() && !bottomState.method_26164(ModBlocks.TARDIS_EXTERIOR_PARTS)) {
            return false;
        }
        class_2680 floorState = world.method_8320(pos.method_10074());
        return !floorState.method_45474() && !floorState.method_26164(ModBlocks.TARDIS_EXTERIOR_PARTS);
    }

    public MinecraftServer getServer() {
        return this.holder.getServer();
    }

    public TardisHolder getHolder() {
        return this.holder;
    }

    public class_5819 getRandom() {
        return this.getInteriorWorld().method_8409();
    }

    public class_2338 getInteriorCenter() {
        return INTERIOR_CENTER;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public Optional<TardisInterior> getInterior() {
        return Optional.ofNullable(MiniTardis.getInteriorManager().getInterior(this.interior));
    }

    public void setCurrentLocation(TardisLocation location) {
        this.setCurrentLocation((Either<TardisLocation, PartialTardisLocation>)Either.left((Object)location));
    }

    public void setCurrentLocation(PartialTardisLocation location) {
        this.setCurrentLocation((Either<TardisLocation, PartialTardisLocation>)Either.right((Object)location));
    }

    public void setCurrentLocation(Either<TardisLocation, PartialTardisLocation> location) {
        this.currentLocation = location;
    }

    public Optional<TardisLocation> getCurrentLandedLocation() {
        return this.currentLocation.left();
    }

    public Either<TardisLocation, PartialTardisLocation> getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean setDestination(@Nullable TardisLocation destination, boolean force) {
        return this.setDestination(Optional.ofNullable(destination), force);
    }

    public boolean setDestination(Optional<TardisLocation> destination, boolean force) {
        if (!(force || this.state.tryChangeCourse(this) && !this.controls.isDestinationLocked())) {
            return false;
        }
        this.destination = destination;
        this.destinationScanner.resetIterators();
        return true;
    }

    public Optional<TardisLocation> getDestination() {
        return this.destination;
    }

    public TardisControl getControls() {
        return this.controls;
    }

    public boolean suggestStateTransition(FlightState newState) {
        boolean accepted = this.state.suggestTransition(this, newState);
        if (accepted) {
            this.state.complete(this);
            this.state = newState;
            newState.init(this);
        }
        return accepted;
    }

    public void forceSetState(FlightState newState) {
        this.state.complete(this);
        this.state = newState;
        newState.init(this);
    }

    public FlightState getState() {
        return this.state;
    }

    public <T extends FlightState> Optional<T> getState(Class<T> stateType) {
        if (stateType.isInstance(this.state)) {
            return Optional.of((FlightState)stateType.cast(this.state));
        }
        return Optional.empty();
    }

    public int getStability() {
        return this.stability;
    }

    public void setStability(int stability) {
        if (stability < this.stability) {
            this.getState(FlyingState.class).ifPresent(state -> {
                state.errorLoops = 2;
            });
            if (this.sparksQueued < 5) {
                this.sparksQueued = Math.min(5, this.sparksQueued + (this.stability - stability) / this.getInteriorWorld().method_8409().method_39332(50, 150));
            }
        }
        this.stability = stability;
    }

    public void destabilize(int amount) {
        this.setStability(Math.max(0, this.getStability() - amount));
    }

    public int getFuel() {
        return this.fuel;
    }

    public boolean addOrDrainFuel(int amount) {
        int oldFuel = this.fuel;
        this.fuel = class_3532.method_15340((int)(oldFuel + amount), (int)0, (int)1000);
        return this.fuel != oldFuel;
    }

    public void addHistoryEntry(HistoryEntry entry) {
        this.controls.getScreenApp(ScreenAppTypes.HISTORY).ifPresent(app -> ((HistoryApp)app).history.add(0, entry));
    }

    public boolean isDoorOpen() {
        return this.doorOpen;
    }

    public boolean setDoorOpen(boolean open, boolean force) {
        if (!force && !this.state.isSolid(this)) {
            return false;
        }
        this.doorOpen = open;
        return true;
    }

    public class_2338 getInteriorDoorPosition() {
        return this.interiorDoorPosition;
    }

    public FlightWave getFlightWave() {
        if (this.flightWave == null) {
            return new FlightWave(0.0, 0.0, 0.0);
        }
        return this.flightWave;
    }

    public void shuffleFlightWave() {
        this.getFlightWave().shuffle(this.getRandom());
    }

    public void createInteriorSparks(boolean damage) {
        this.findSparkPos().ifPresent(pos -> {
            class_3218 world = this.getInteriorWorld();
            world.method_14199((class_2394)class_2398.field_11248, pos.field_1352, pos.field_1351, pos.field_1350, 20, 0.0, 0.0, 0.0, 0.2);
            world.method_14199((class_2394)class_2398.field_11239, pos.field_1352, pos.field_1351, pos.field_1350, 10, 0.0, 0.0, 0.0, 0.2);
            world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14905, class_3419.field_15245, 2.0f, 0.5f + world.method_8409().method_43057());
        });
    }

    private Optional<class_243> findSparkPos() {
        class_3218 world = this.getInteriorWorld();
        for (class_2338 pos : class_2338.method_34848((class_5819)world.method_8409(), (int)128, (class_2338)this.getInteriorCenter(), (int)16)) {
            if (!world.method_8320(pos).method_45474()) continue;
            for (class_2350 direction : class_2350.values()) {
                if (!world.method_8320(pos.method_10093(direction)).method_26206((class_1922)world, pos, direction.method_10153())) continue;
                return Optional.of(class_243.method_24953((class_2382)pos).method_1019(class_243.method_24954((class_2382)direction.method_10163()).method_1021(0.5)));
            }
        }
        return Optional.empty();
    }

    public void setSparksQueued(int sparks) {
        this.sparksQueued = sparks;
    }

    public static boolean isTardis(class_5321<class_1937> worldKey) {
        return worldKey.method_29177().method_12836().equals("mini_tardis") && worldKey.method_29177().method_12832().startsWith("tardis/");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tardis tardis = (Tardis)o;
        return this.uuid.equals(tardis.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

