/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_5819;

public class FlightWave {
    public static final Codec<FlightWave> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("magnitude").forGetter(FlightWave::getMagnitude), (App)Codec.DOUBLE.fieldOf("period").forGetter(FlightWave::getPeriod), (App)Codec.DOUBLE.fieldOf("offset").forGetter(FlightWave::getOffset)).apply((Applicative)instance, FlightWave::new));
    private double magnitude;
    private double period;
    private double offset;

    public FlightWave(double magnitude, double period, double offset) {
        this.magnitude = this.snap(magnitude);
        this.period = this.snap(period);
        this.offset = this.snap(offset);
    }

    public FlightWave(class_5819 random) {
        this(0.0, 0.0, 0.0);
        this.shuffle(random);
    }

    public void shuffle(class_5819 random) {
        this.magnitude = 0.1 + this.snap(random.method_43058()) * 0.9;
        this.period = 0.1 + this.snap(random.method_43058()) * 0.9;
        this.offset = this.snap(random.method_43058());
    }

    private double snap(double x) {
        return (double)Math.round(x * 10.0) / 10.0;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public double getPeriod() {
        return this.period;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setMagnitude(double magnitude) {
        this.magnitude = this.snap(magnitude);
    }

    public void setPeriod(double period) {
        this.period = this.snap(period);
    }

    public void setOffset(double offset) {
        this.offset = this.snap(offset);
    }

    public int getValue(int i) {
        return (int)Math.round((switch (i) {
            case 0 -> (this.magnitude - 0.1) / 0.9;
            case 1 -> (this.period - 0.1) / 0.9;
            case 2 -> this.offset;
            default -> 0.0;
        }) * 10.0);
    }

    public void setValue(int i, int value) {
        double scaled = (double)value / 10.0;
        switch (i) {
            case 0: {
                this.magnitude = 0.1 + this.snap(scaled) * 0.9;
                break;
            }
            case 1: {
                this.period = 0.1 + this.snap(scaled) * 0.9;
                break;
            }
            case 2: {
                this.offset = this.snap(scaled);
            }
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlightWave)) {
            return false;
        }
        FlightWave that = (FlightWave)o;
        return Double.compare(this.magnitude, that.magnitude) == 0 && Double.compare(this.period, that.period) == 0 && Double.compare(this.offset, that.offset) == 0;
    }

    public int hashCode() {
        int result = Double.hashCode(this.magnitude);
        result = 31 * result + Double.hashCode(this.period);
        result = 31 * result + Double.hashCode(this.offset);
        return result;
    }
}

