/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.component;

import dev.enjarai.minitardis.block.ModBlocks;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DestinationScanner {
    public static final int RANGE = 96;
    public static final int TOTAL_BLOCKS = 9216;
    private final Tardis tardis;
    private final int maxPerTick;
    private final byte[] xAxis = new byte[9216];
    private final byte[] zAxis = new byte[9216];
    private Iterator<Vector2i> xIterator = DestinationScanner.newIterator();
    private Iterator<Vector2i> zIterator = DestinationScanner.newIterator();
    private boolean shouldScanNextTick;
    private boolean isZAxis;

    public DestinationScanner(Tardis tardis, int maxPerTick) {
        this.tardis = tardis;
        this.maxPerTick = maxPerTick;
    }

    public void tick() {
        if (this.shouldScanNextTick) {
            this.tardis.getDestinationWorld().ifPresent(world -> {
                TardisLocation location = this.tardis.getDestination().get();
                if (this.isZAxis) {
                    this.zIterator = this.updateAxis((class_3218)world, this.zAxis, this.zIterator, (pos3, pos2) -> pos3.method_10101((class_2382)location.pos()).method_10100(0, pos2.y, pos2.x));
                } else {
                    this.xIterator = this.updateAxis((class_3218)world, this.xAxis, this.xIterator, (pos3, pos2) -> pos3.method_10101((class_2382)location.pos()).method_10100(pos2.x, pos2.y, 0));
                }
            });
            this.shouldScanNextTick = false;
        } else {
            this.resetIterators();
        }
    }

    public byte getFor(int x, int y) {
        return this.getFor(DestinationScanner.getIndex(x, y));
    }

    public byte getFor(int pos) {
        return this.isZAxis ? this.zAxis[pos] : this.xAxis[pos];
    }

    public void useXAxis() {
        this.isZAxis = false;
    }

    public void useZAxis() {
        this.isZAxis = true;
    }

    public boolean isZAxis() {
        return this.isZAxis;
    }

    public void resetIterators() {
        this.xIterator = DestinationScanner.newIterator();
        this.zIterator = DestinationScanner.newIterator();
    }

    public void shouldScanNextTick() {
        this.shouldScanNextTick = true;
    }

    private Iterator<Vector2i> updateAxis(class_3218 world, byte[] axis, Iterator<Vector2i> iterator, BiConsumer<class_2338.class_2339, Vector2i> posApplier) {
        class_2338.class_2339 pos3 = new class_2338.class_2339();
        Vector2i pos2 = new Vector2i();
        for (int i = 0; i < this.maxPerTick; ++i) {
            byte value;
            if (!iterator.hasNext()) {
                return DestinationScanner.newIterator();
            }
            pos2.set((Vector2ic)iterator.next());
            posApplier.accept(pos3, pos2);
            pos2.add(47, 47);
            class_2680 state = world.method_8320((class_2338)pos3);
            axis[DestinationScanner.getIndex((Vector2i)pos2)] = value = this.getValue(state, world, (class_2338)pos3);
        }
        return iterator;
    }

    private byte getValue(class_2680 state, class_3218 world, class_2338 pos) {
        if (state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            return (byte)class_3620.field_15984.field_16021;
        }
        if (state.method_26227().method_39360((class_3611)class_3612.field_15908)) {
            return (byte)class_3620.field_15987.field_16021;
        }
        if (state.method_45474()) {
            return (byte)class_3620.field_16009.field_16021;
        }
        if (state.method_26164(ModBlocks.TARDIS_EXTERIOR_PARTS)) {
            return (byte)class_3620.field_15980.field_16021;
        }
        return (byte)state.method_26205((class_1922)world, (class_2338)pos).field_16021;
    }

    public static int getIndex(Vector2i pos) {
        return DestinationScanner.getIndex(pos.x, pos.y);
    }

    public static int getIndex(int x, int y) {
        return (x + y * 96) % 9216;
    }

    public static Vector2i getPos(int index) {
        return new Vector2i(index % 96 - 48, index / 96 - 48);
    }

    private static Iterator<Vector2i> newIterator() {
        return new Iterator<Vector2i>(){
            final Vector2i direction = new Vector2i(1, 0);
            int segment_length = 1;
            final Vector2i current = new Vector2i(0, 0);
            int segment_passed = 0;
            int k = 0;

            @Override
            public boolean hasNext() {
                return this.k < 9216;
            }

            @Override
            public Vector2i next() {
                ++this.k;
                this.current.add((Vector2ic)this.direction);
                ++this.segment_passed;
                if (this.segment_passed == this.segment_length) {
                    this.segment_passed = 0;
                    this.direction.set(-this.direction.y, this.direction.x);
                    if (this.direction.y == 0) {
                        ++this.segment_length;
                    }
                }
                return this.current;
            }
        };
    }
}

