/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.enjarai.minitardis.ModCCAComponents;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisHolder;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.TardisReference;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.item.FloppyItem;
import dev.enjarai.minitardis.item.ModItems;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class TardisCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minitardis").requires(Permissions.require((String)"command.minitardis", (int)2))).then(class_2170.method_9247((String)"create").executes(TardisCommand::create))).then(class_2170.method_9247((String)"restore").then(class_2170.method_9247((String)"exterior").then(class_2170.method_9244((String)"tardis", (ArgumentType)class_5242.method_27643()).suggests(TardisCommand::suggestTardii).executes(context -> TardisCommand.restoreExterior((CommandContext<class_2168>)context, class_5242.method_27645((CommandContext)context, (String)"tardis"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"floppy").then(class_2170.method_9247((String)"install").then(class_2170.method_9244((String)"app", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270((Iterable)ScreenAppType.REGISTRY.method_10235(), (SuggestionsBuilder)builder)).executes(context -> TardisCommand.installApps((CommandContext<class_2168>)context, List.of((ScreenApp)Objects.requireNonNull((ScreenAppType)ScreenAppType.REGISTRY.method_10223(class_2232.method_9443((CommandContext)context, (String)"app"))).constructor().get())))))).then(class_2170.method_9247((String)"installAll").executes(context -> TardisCommand.installApps((CommandContext<class_2168>)context, ScreenAppType.REGISTRY.method_10220().map(type -> (ScreenApp)type.constructor().get()).toList()))))).then(class_2170.method_9247((String)"door").then(class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"tardis", (ArgumentType)class_5242.method_27643()).suggests(TardisCommand::suggestTardii).executes(context -> TardisCommand.toggleDoor((CommandContext<class_2168>)context, class_5242.method_27645((CommandContext)context, (String)"tardis"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"refuel").executes(context -> TardisCommand.refuel((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"tardis", (ArgumentType)class_5242.method_27643()).suggests(TardisCommand::suggestTardii).executes(context -> TardisCommand.refuel((CommandContext<class_2168>)context, class_5242.method_27645((CommandContext)context, (String)"tardis")))))).then(class_2170.method_9247((String)"state").then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"state", (ArgumentType)class_2232.method_9441()).suggests(TardisCommand::suggestStates).executes(context -> TardisCommand.setState((CommandContext<class_2168>)context, class_2232.method_9443((CommandContext)context, (String)"state"), null))).then(class_2170.method_9244((String)"tardis", (ArgumentType)class_5242.method_27643()).suggests(TardisCommand::suggestTardii).executes(context -> TardisCommand.setState((CommandContext<class_2168>)context, class_2232.method_9443((CommandContext)context, (String)"state"), class_5242.method_27645((CommandContext)context, (String)"tardis"))))))));
    }

    private static int create(CommandContext<class_2168> context) {
        TardisHolder holder = TardisCommand.getHolder(context);
        class_2338 pos = class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222());
        class_5321 worldKey = ((class_2168)context.getSource()).method_9225().method_27983();
        TardisLocation location = new TardisLocation((class_5321<class_1937>)worldKey, pos, class_2350.field_11043);
        new Tardis(holder, location, Tardis.DEFAULT_INTERIOR);
        return 1;
    }

    private static int restoreExterior(CommandContext<class_2168> context, UUID uuid) {
        TardisCommand.getHolder(context).getTardis(uuid).ifPresent(Tardis::buildExterior);
        return 1;
    }

    private static int toggleDoor(CommandContext<class_2168> context, UUID uuid) {
        TardisCommand.getHolder(context).getTardis(uuid).ifPresent(t -> t.setDoorOpen(!t.isDoorOpen(), false));
        return 1;
    }

    private static int refuel(CommandContext<class_2168> context, @Nullable UUID uuid) {
        Optional<Tardis> tardis = uuid == null ? TardisCommand.getTardis((class_1937)((class_2168)context.getSource()).method_9225()) : TardisCommand.getHolder(context).getTardis(uuid);
        tardis.ifPresent(t -> t.addOrDrainFuel(1000));
        return 1;
    }

    private static int setState(CommandContext<class_2168> context, class_2960 stateId, @Nullable UUID uuid) {
        if (FlightState.CONSTRUCTORS.containsKey(stateId)) {
            Supplier<? extends FlightState> state = FlightState.CONSTRUCTORS.get(stateId);
            Optional<Tardis> tardis = uuid == null ? TardisCommand.getTardis((class_1937)((class_2168)context.getSource()).method_9225()) : TardisCommand.getHolder(context).getTardis(uuid);
            tardis.ifPresent(t -> t.forceSetState((FlightState)state.get()));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestTardii(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(((TardisHolder)ModCCAComponents.TARDIS_HOLDER.get((Object)((class_2168)context.getSource()).method_9211().method_27728())).getAllTardii().stream().map(Tardis::uuid).map(UUID::toString), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestStates(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(FlightState.CONSTRUCTORS.keySet().stream().map(class_2960::toString), (SuggestionsBuilder)builder);
    }

    private static int installApps(CommandContext<class_2168> context, List<? extends ScreenApp> apps) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        class_1799 handStack = player.method_6047();
        if (!handStack.method_31574((class_1792)ModItems.FLOPPY)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Please hold a Floppy in your main hand"), false);
            return 0;
        }
        for (ScreenApp screenApp : apps) {
            FloppyItem.addApp(handStack, screenApp);
        }
        return apps.size();
    }

    private static TardisHolder getHolder(CommandContext<class_2168> context) {
        return (TardisHolder)ModCCAComponents.TARDIS_HOLDER.get((Object)((class_2168)context.getSource()).method_9211().method_27728());
    }

    private static Optional<Tardis> getTardis(class_1937 world) {
        return ((TardisReference)world.getComponent(ModCCAComponents.TARDIS_REFERENCE)).getTardis();
    }
}

