/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.enjarai.minitardis.block.console.ConsoleScreenBlock;
import dev.enjarai.minitardis.block.console.ConsoleScreenBlockEntity;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ConsoleScreenBlockRenderer
implements class_827<ConsoleScreenBlockEntity> {
    private static final Map<ConsoleScreenBlockEntity, CacheEntry> TEXTURE_CACHE = new WeakHashMap<ConsoleScreenBlockEntity, CacheEntry>();
    private static final int DURATION = 100;
    private final class_776 blockRenderManager;
    private final class_918 itemRenderer;

    public ConsoleScreenBlockRenderer(class_5614.class_5615 ctx) {
        this.blockRenderManager = ctx.method_32141();
        this.itemRenderer = ctx.method_43335();
    }

    public static void tick() {
        TEXTURE_CACHE.entrySet().removeIf(e -> {
            if (((CacheEntry)e.getValue()).ticksSinceUsed++ >= 100L) {
                ((CacheEntry)e.getValue()).texture.close();
                return true;
            }
            return false;
        });
    }

    public static class_1043 getTexture(ConsoleScreenBlockEntity entity) {
        CacheEntry entry = TEXTURE_CACHE.get(entity);
        int displayHash = entity.display.hashCode();
        if (entry != null) {
            if (entry.displayHash == displayHash) {
                entry.ticksSinceUsed = 0L;
                return entry.texture;
            }
            entry.texture.close();
        }
        CacheEntry newEntry = new CacheEntry(new class_1043(entity.display.getWidth(), entity.display.getHeight(), false), displayHash);
        class_1011 nativeImage = newEntry.texture.method_4525();
        for (int x = 0; x < entity.display.getWidth(); ++x) {
            for (int y = 0; y < entity.display.getHeight(); ++y) {
                int color = CanvasUtils.ABGRfromLimitedColor(entity.display.getRaw(x, y)) | 0xFF000000;
                nativeImage.method_4305(x, y, color);
            }
        }
        newEntry.texture.method_4524();
        TEXTURE_CACHE.put(entity, newEntry);
        return newEntry.texture;
    }

    public void render(ConsoleScreenBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2350 facing = (class_2350)entity.method_11010().method_11654((class_2769)ConsoleScreenBlock.FACING);
        matrices.method_22903();
        Vector3f offset = facing.method_23955().mul(-0.5f);
        matrices.method_46416(offset.x(), offset.y(), offset.z());
        class_1087 model = this.blockRenderManager.method_3351().method_3335(entity.method_11010());
        class_5819 random = class_5819.method_43049((long)42L);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_4722.method_24074());
        class_4587.class_4665 matrix = matrices.method_23760();
        for (class_777 quad : model.method_4707(null, null, random)) {
            vertexConsumer.method_22919(matrix, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f + facing.method_10144()));
        matrices.method_46416(-0.5f, 0.0f, -0.5f);
        class_1799 stack = entity.inventory.method_5438(0);
        if (!stack.method_7960()) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.2f, 0.08f);
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            this.itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, matrices, vertexConsumers, entity.method_10997(), 42);
            matrices.method_22909();
        }
        if (!entity.getInactive()) {
            matrices.method_46416(0.0f, 0.0f, -0.015625f);
            class_1043 texture = ConsoleScreenBlockRenderer.getTexture(entity);
            RenderSystem.setShaderTexture((int)0, (int)texture.method_4624());
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f position = matrices.method_23760().method_23761();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(position, 0.0f, 0.125f, 0.0f).method_22913(1.0f, 1.0f).method_39415(-1);
            bufferBuilder.method_22918(position, 0.0f, 0.875f, 0.0f).method_22913(1.0f, 0.0f).method_39415(-1);
            bufferBuilder.method_22918(position, 1.0f, 0.875f, 0.0f).method_22913(0.0f, 0.0f).method_39415(-1);
            bufferBuilder.method_22918(position, 1.0f, 0.125f, 0.0f).method_22913(0.0f, 1.0f).method_39415(-1);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        matrices.method_22909();
    }

    static final class CacheEntry {
        private final class_1043 texture;
        private final int displayHash;
        private long ticksSinceUsed;

        CacheEntry(class_1043 texture, int displayHash) {
            this.texture = texture;
            this.displayHash = displayHash;
            this.ticksSinceUsed = 0L;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CacheEntry that = (CacheEntry)obj;
            return Objects.equals(this.texture, that.texture) && this.displayHash == that.displayHash && this.ticksSinceUsed == that.ticksSinceUsed;
        }

        public int hashCode() {
            return Objects.hash(this.texture, this.displayHash, this.ticksSinceUsed);
        }

        public String toString() {
            return "CacheEntry[texture=" + String.valueOf(this.texture) + ", displayHash=" + this.displayHash + ", lastUsedTick=" + this.ticksSinceUsed + "]";
        }
    }
}

