/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.canvas;

import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasImage;
import dev.enjarai.minitardis.component.screen.canvas.patbox.DrawableCanvas;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class TardisCanvasUtils {
    private static final String PATH_PREFIX = "textures/map";
    private static final CanvasImage BLANK_IMAGE = new CanvasImage(0, 0);
    private static Map<class_2960, CanvasImage> images = new HashMap<class_2960, CanvasImage>();

    public static CanvasImage getSprite(class_2960 id) {
        return images.getOrDefault(id, BLANK_IMAGE);
    }

    public static CanvasImage getSprite(String path) {
        return TardisCanvasUtils.getSprite(MiniTardis.id(path));
    }

    public static void drawCenteredText(DrawableCanvas canvas, String text, int x, int y, short color) {
        int width = DefaultFonts.VANILLA.getTextWidth(text, 8.0);
        DefaultFonts.VANILLA.drawText(canvas, text, x - width / 2, y, 8.0, color);
    }

    public static void load() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return MiniTardis.id("canvas_images");
            }

            public void method_14491(class_3300 manager) {
                HashMap<class_2960, CanvasImage> newImages = new HashMap<class_2960, CanvasImage>();
                manager.method_14488(TardisCanvasUtils.PATH_PREFIX, id -> id.method_12832().endsWith(".png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        newImages.put(id.method_45134(path -> path.substring(TardisCanvasUtils.PATH_PREFIX.length() + 1, path.length() - 4)), CanvasImage.from(ImageIO.read(stream)));
                    }
                    catch (IOException | NoSuchElementException e) {
                        MiniTardis.LOGGER.error("Failed to load canvas image " + String.valueOf(id), (Throwable)e);
                    }
                });
                images = newImages;
            }
        });
    }
}

