/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.canvas;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class BadAppleConverter {
    public static void convert(Path oldPath, Path newPath) throws IOException {
        List<String> lines = Files.readAllLines(oldPath);
        byte[][] goodApple = new byte[lines.size()][];
        for (int i = 0; i < goodApple.length; ++i) {
            String line = lines.get(i);
            byte[] lineData = new byte[line.length()];
            for (int j = 0; j < lineData.length; ++j) {
                lineData[j] = (byte)Character.getNumericValue(line.charAt(j));
            }
            goodApple[i] = lineData;
        }
        int frames = goodApple.length;
        int width = 128;
        int height = 96;
        byte[] mediumApple = new byte[frames * width * height];
        for (int frame = 0; frame < frames; ++frame) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    mediumApple[frame * width * height + x * height + y] = goodApple[frame][y * width + x];
                }
            }
        }
        byte[] badApple = new byte[mediumApple.length / 2];
        for (int frame = 0; frame < frames; ++frame) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    int index = frame * width * height + x * height + y * 2;
                    int pixel1 = mediumApple[index] << 4;
                    byte pixel2 = mediumApple[index + 1];
                    badApple[index / 2] = (byte)(pixel1 | pixel2);
                }
            }
        }
        try (GZIPOutputStream stream = new GZIPOutputStream(Files.newOutputStream(newPath, new OpenOption[0]));){
            stream.write(width);
            stream.write(height);
            stream.write(badApple);
        }
    }
}

