/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.block.console;

import dev.enjarai.minitardis.MiniTardis;
import dev.enjarai.minitardis.block.TardisAware;
import dev.enjarai.minitardis.canvas.TardisCanvasUtils;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisControl;
import dev.enjarai.minitardis.component.screen.app.AppView;
import dev.enjarai.minitardis.component.screen.app.ScreenApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppType;
import dev.enjarai.minitardis.component.screen.canvas.CanvasColors;
import dev.enjarai.minitardis.component.screen.canvas.TardisScreenView;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasImage;
import dev.enjarai.minitardis.component.screen.canvas.patbox.CanvasUtils;
import dev.enjarai.minitardis.component.screen.canvas.patbox.SubView;
import dev.enjarai.minitardis.component.screen.canvas.patbox.font.DefaultFonts;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1277;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public abstract class ScreenBlockEntity
extends class_2586
implements TardisAware {
    private static final int MAX_DISPLAY_DISTANCE = 30;
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(4, (ThreadFactory)new DefaultThreadFactory(ScreenBlockEntity.class, true));
    public static final KeyedEndec<CanvasImage> IMAGE_ENDEC = CanvasImage.ENDEC.keyed("display", () -> new CanvasImage(128, 96));
    public final class_5819 drawRandom = new class_6575(69420L);
    protected final TardisScreenView canvas;
    public CanvasImage display;
    protected int lastDisplayHash = 0;
    private final List<class_3222> addedPlayers = new ArrayList<class_3222>();
    public class_1277 inventory = new class_1277(1);
    public short backgroundColor = CanvasColors.BACKGROUND;
    @Nullable
    AppView currentView;
    @Nullable
    class_2960 selectedApp;
    @Nullable
    private ScheduledFuture<?> threadFuture;
    private boolean inactive;

    public ScreenBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.display = new CanvasImage(128, 96);
        this.canvas = new TardisScreenView(this.display);
    }

    protected abstract class_2338 getPos(class_2338 var1, class_2680 var2);

    protected abstract class_2350 getFacing(class_2338 var1, class_2680 var2);

    protected abstract class_2470 getRotation(class_2338 var1, class_2680 var2);

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.selectedApp != null) {
            nbt.method_10582("selectedApp", this.selectedApp.toString());
        }
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10575("backgroundColor", this.backgroundColor);
    }

    protected void writeNetNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (!this.inactive) {
            nbt.put(IMAGE_ENDEC, (Object)this.display);
        }
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10556("inactive", this.inactive);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.display = (CanvasImage)nbt.get(IMAGE_ENDEC);
        this.canvas.setSource(this.display);
        if (nbt.method_10545("selectedApp")) {
            this.selectedApp = class_2960.method_12829((String)nbt.method_10558("selectedApp"));
        }
        if (nbt.method_10545("inventory")) {
            this.inventory.method_7659(nbt.method_10554("inventory", 10), registryLookup);
        }
        if (nbt.method_10545("backgroundColor")) {
            this.backgroundColor = nbt.method_10568("backgroundColor");
        }
        if (nbt.method_10545("inactive")) {
            this.inactive = nbt.method_10577("inactive");
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        this.writeNetNbt(nbtCompound, registryLookup);
        return nbtCompound;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.selectedApp != null && this.currentView == null) {
                this.getTardis(world).ifPresent(tardis -> tardis.getControls().getScreenApp((ScreenAppType)ScreenAppType.REGISTRY.method_10223(this.selectedApp)).ifPresent(app -> {
                    this.currentView = app.getView(tardis.getControls());
                    this.currentView.screenOpen(this);
                }));
            }
            Boolean isDisabled = this.getTardis(world).map(t -> !t.getState().isPowered((Tardis)t)).orElse(true);
            Boolean viewOverridden = this.getTardis(world).map(t -> t.getState().overrideScreenImage((Tardis)t)).orElse(false);
            this.setInactive(isDisabled != false && viewOverridden == false);
            List nearby = serverWorld.method_18766(player -> player.method_24515().method_19455((class_2382)pos) <= 30);
            List shouldSyncWith = this.getInactive() ? List.of() : nearby;
            this.addedPlayers.removeIf(player -> {
                if (!shouldSyncWith.contains(player)) {
                    if (player.method_37908() == this.method_10997()) {
                        player.field_13987.method_14364(this.method_38235());
                    }
                    return true;
                }
                return false;
            });
            shouldSyncWith.forEach(player -> {
                if (!this.addedPlayers.contains(player)) {
                    player.field_13987.method_14364(this.method_38235());
                    this.addedPlayers.add((class_3222)player);
                }
            });
            if (this.addedPlayers.isEmpty() && shouldSyncWith.isEmpty() && this.threadFuture != null) {
                this.threadFuture.cancel(true);
                this.threadFuture = null;
            }
            if (!shouldSyncWith.isEmpty() && this.threadFuture == null) {
                this.getTardis(world).ifPresent(tardis -> {
                    this.threadFuture = executor.scheduleAtFixedRate(() -> {
                        try {
                            this.refresh((Tardis)tardis);
                        }
                        catch (Exception e) {
                            MiniTardis.LOGGER.error("Tardis screen draw thread failed:", (Throwable)e);
                            throw e;
                        }
                    }, 0L, 33L, TimeUnit.MILLISECONDS);
                });
            }
            if (!shouldSyncWith.isEmpty() && this.currentView != null && !viewOverridden.booleanValue()) {
                this.currentView.screenTick(this);
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        this.addedPlayers.clear();
        if (this.threadFuture != null) {
            this.threadFuture.cancel(true);
        }
    }

    public void cleanUpForRemoval() {
        this.addedPlayers.clear();
        if (this.threadFuture != null) {
            this.threadFuture.cancel(true);
        }
        if (this.currentView != null) {
            this.currentView.screenClose(this);
        }
    }

    public void pushUpdates() {
        int hash = this.display.hashCode();
        if (hash != this.lastDisplayHash) {
            this.addedPlayers.forEach(player -> player.field_13987.method_14364(this.method_38235()));
            this.lastDisplayHash = hash;
        }
    }

    private void refresh(Tardis tardis) {
        this.canvas.fillRaw(this.backgroundColor);
        TardisControl controls = tardis.getControls();
        if (!tardis.getState().overrideScreenImage(tardis)) {
            if (this.currentView != null) {
                this.currentView.drawBackground(this, this.canvas);
                this.currentView.draw(this, this.canvas);
                this.canvas.draw(98, 2, TardisCanvasUtils.getSprite("screen_side_button"));
                DefaultFonts.VANILLA.drawText(this.canvas, "Menu", 100, 6, 8.0, CanvasUtils.toLimitedColor(0xFFFFFF));
            } else {
                this.canvas.draw(0, 0, TardisCanvasUtils.getSprite("screen_background"));
                List<ScreenApp> apps = controls.getAllApps();
                for (int i = 0; i < apps.size(); ++i) {
                    ScreenApp app = apps.get(i);
                    app.drawIcon(controls, this, new SubView(this.canvas, this.getAppX(i), this.getAppY(i), 24, 24));
                }
            }
        } else {
            tardis.getState().drawScreenImage(controls, this.canvas, this);
        }
        int stability = tardis.getStability();
        if (this.drawRandom.method_39332(0, 2000) < 50 - stability) {
            this.canvas.addGlitchFrames(30);
        }
        this.canvas.refresh(this.drawRandom);
        this.pushUpdates();
    }

    protected void handleClick(class_3222 player, class_5536 type, int x, int y) {
        this.getTardis(this.method_10997()).ifPresent(tardis -> {
            if (tardis.getState().overrideScreenImage((Tardis)tardis)) {
                return;
            }
            TardisControl controls = tardis.getControls();
            if (this.currentView != null) {
                if (type == class_5536.field_27014 && x >= 98 && x < 126 && y >= 18 && y < 32) {
                    this.closeApp();
                    this.playClickSound(0.8f);
                } else {
                    this.currentView.onClick(this, player, type, x, y - 16);
                }
            } else {
                List<ScreenApp> apps = controls.getAllApps();
                if (type == class_5536.field_27014) {
                    for (int i = 0; i < apps.size(); ++i) {
                        int appX = this.getAppX(i);
                        int appY = this.getAppY(i) + 16;
                        if (x < appX || x >= appX + 24 || y < appY || y >= appY + 24) continue;
                        ScreenApp app = apps.get(i);
                        this.selectedApp = app.getId();
                        this.currentView = app.getView(controls);
                        this.currentView.screenOpen(this);
                        this.playClickSound(1.5f);
                        this.method_5431();
                    }
                }
            }
        });
    }

    private int getAppX(int i) {
        return i % 4 * 30 + 6;
    }

    private int getAppY(int i) {
        return i / 4 * 30 + 6;
    }

    public void closeApp() {
        if (this.currentView == null) {
            MiniTardis.LOGGER.error("Tried to close app while currentView is null!");
            return;
        }
        this.currentView.screenClose(this);
        this.selectedApp = null;
        this.currentView = null;
        this.method_5431();
    }

    public boolean getInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        boolean old = this.inactive;
        this.inactive = inactive;
        if (old != inactive) {
            this.method_5431();
        }
    }

    public void playClickSound(float pitch) {
        this.playSound((class_3414)class_3417.field_18311.comp_349(), 0.5f, pitch);
    }

    public void playSound(class_3414 soundEvent, float volume, float pitch) {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8396(null, this.method_11016(), soundEvent, class_3419.field_15245, volume, pitch);
        }
    }
}

