/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.minitardis.block;

import com.google.common.collect.Iterables;
import dev.enjarai.minitardis.ModCCAComponents;
import dev.enjarai.minitardis.ModSounds;
import dev.enjarai.minitardis.block.ModBlocks;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisHolder;
import dev.enjarai.minitardis.component.TardisInterior;
import dev.enjarai.minitardis.component.TardisLocation;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class MakeshiftEngineBlockEntity
extends class_2586 {
    public static final int DEMAT_TIME = 200;
    private int dematTicks = -1;

    public MakeshiftEngineBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MAKESHIFT_ENGINE_ENTITY, pos, state);
    }

    public boolean tryHandbrake(boolean active) {
        if (this.dematTicks < 0) {
            if (active && this.isValidScrapTardis() && this.field_11863 != null) {
                this.dematTicks = 0;
                this.field_11863.method_45447(null, this.method_11016(), ModSounds.TARDIS_TAKEOFF, class_3419.field_15245);
                return true;
            }
        } else {
            this.crash();
            return true;
        }
        return false;
    }

    public void tick(class_3218 world, class_2338 pos, class_2680 state) {
        if (this.dematTicks >= 0) {
            ++this.dematTicks;
            this.tickParticleSphere(world, Math.min(this.dematTicks / 2, 100));
            if (!this.isValidScrapTardis()) {
                this.crash();
            }
            if (this.dematTicks >= 200) {
                Tardis tardis = this.createTardis((class_1937)world);
                if (tardis != null) {
                    this.moveIntoTardis((class_1937)world, tardis);
                }
                this.dematTicks = -1;
            }
        }
    }

    protected void tickParticleSphere(class_3218 world, int count) {
        class_5819 random = world.method_8409();
        class_243 centerPos = this.field_11867.method_46558();
        for (int i = 0; i < count; ++i) {
            double horizontal = random.method_43058() * Math.PI * 0.6;
            double vertical = random.method_43058() * Math.PI * 2.0;
            double x = Math.sin(horizontal) * Math.cos(vertical) * 3.0;
            double y = Math.cos(horizontal) * 3.0;
            double z = Math.sin(horizontal) * Math.sin(vertical) * 3.0;
            world.method_14199((class_2394)class_2398.field_11207, centerPos.method_10216() + x, centerPos.method_10214() + y, centerPos.method_10215() + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void crash() {
        this.dematTicks = -1;
    }

    protected Tardis createTardis(class_1937 world) {
        if (world.method_8503() == null) {
            return null;
        }
        TardisHolder tardisHolder = (TardisHolder)ModCCAComponents.TARDIS_HOLDER.get((Object)world.method_8503().method_27728());
        class_5321 worldKey = world.method_27983();
        TardisLocation location = new TardisLocation((class_5321<class_1937>)worldKey, this.field_11867, class_2350.field_11043);
        return new Tardis(tardisHolder, location);
    }

    protected void moveIntoTardis(class_1937 world, Tardis tardis) {
        class_2338 source;
        class_3218 tardisWorld = tardis.getInteriorWorld();
        class_2338 targetPos = Tardis.INTERIOR_CENTER.method_10081(tardis.getInterior().map(TardisInterior::scrappyLandingPosition).orElse(class_2382.field_11176)).method_10084();
        Iterable blockIterator = Iterables.concat((Iterable)class_2338.method_10094((int)-1, (int)-1, (int)-2, (int)1, (int)3, (int)2), (Iterable)class_2338.method_10094((int)2, (int)-1, (int)-1, (int)2, (int)3, (int)1), (Iterable)class_2338.method_10094((int)-2, (int)-1, (int)-1, (int)-2, (int)3, (int)1));
        for (class_2338 blockPos : blockIterator) {
            source = this.field_11867.method_10081((class_2382)blockPos);
            class_2338 target = targetPos.method_10081((class_2382)blockPos);
            class_2680 state = world.method_8320(source);
            if (state.method_27852((class_2248)ModBlocks.MAKESHIFT_ENGINE)) {
                state = class_2246.field_10033.method_9564();
            }
            tardisWorld.method_8652(target, state, 2);
        }
        for (class_2338 blockPos : blockIterator) {
            source = this.field_11867.method_10081((class_2382)blockPos);
            world.method_8652(source, class_2246.field_10124.method_9564(), 32);
        }
        class_238 entityBox = new class_238(this.field_11867.method_10074().method_10077(2).method_10089(2).method_46558(), this.field_11867.method_10086(3).method_10076(2).method_10088(2).method_46558());
        for (class_1297 entity : world.method_8390(class_1297.class, entityBox, e -> true)) {
            class_243 relativePos = entity.method_19538().method_1020(this.field_11867.method_46558());
            class_243 target = relativePos.method_1019(targetPos.method_46558());
            entity.method_48105(tardisWorld, target.field_1352, target.field_1351, target.field_1350, Set.of(), entity.method_36454(), entity.method_36455());
        }
    }

    protected boolean isValidScrapTardis() {
        if (this.field_11863 == null || !this.field_11863.method_8320(this.field_11867).method_27852((class_2248)ModBlocks.MAKESHIFT_ENGINE)) {
            return false;
        }
        class_2338 floorPos = this.field_11867.method_10074();
        Iterable floorIterator = Iterables.concat((Iterable)class_2338.method_10097((class_2338)floorPos.method_10077(2).method_10078(), (class_2338)floorPos.method_10076(2).method_10067()), (Iterable)class_2338.method_10097((class_2338)floorPos.method_10072().method_10089(2), (class_2338)floorPos.method_10095().method_10089(2)), (Iterable)class_2338.method_10097((class_2338)floorPos.method_10072().method_10088(2), (class_2338)floorPos.method_10095().method_10088(2)));
        for (class_2338 floorTile : floorIterator) {
            if (this.field_11863.method_8320(floorTile).method_27852((class_2248)ModBlocks.TARDIS_PLATING)) continue;
            return false;
        }
        return true;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("demat_ticks", this.dematTicks);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.dematTicks = nbt.method_10550("demat_ticks");
    }
}

