/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.minitardis_cc_bridge.cc;

import com.thejebforge.minitardis_cc_bridge.util.Utils;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.enjarai.minitardis.block.TardisAware;
import dev.enjarai.minitardis.component.PartialTardisLocation;
import dev.enjarai.minitardis.component.Tardis;
import dev.enjarai.minitardis.component.TardisLocation;
import dev.enjarai.minitardis.component.flight.BootingUpState;
import dev.enjarai.minitardis.component.flight.DisabledState;
import dev.enjarai.minitardis.component.flight.DriftingState;
import dev.enjarai.minitardis.component.flight.FlightState;
import dev.enjarai.minitardis.component.flight.FlyingState;
import dev.enjarai.minitardis.component.screen.app.DimensionsApp;
import dev.enjarai.minitardis.component.screen.app.ScreenAppTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class Peripheral
implements IPeripheral,
TardisAware {
    private final class_1937 world;

    public Peripheral(class_1937 world) {
        this.world = world;
    }

    @LuaFunction
    public final boolean isLinked() {
        return this.getTardis(this.world).isPresent();
    }

    private Tardis getTardisWithException() throws LuaException {
        return (Tardis)this.getTardis(this.world).orElseThrow(() -> new LuaException("Peripheral is not located inside of a TARDIS"));
    }

    private <T> T mainThread(LuaSupplier<T> func) throws LuaException {
        CompletableFuture future = new CompletableFuture();
        this.world.method_8503().execute(() -> {
            try {
                future.complete(func.get());
            }
            catch (LuaException e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return future.join();
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof LuaException) {
                LuaException lua = (LuaException)throwable;
                throw lua;
            }
            throw e;
        }
    }

    @LuaFunction
    public final String getState() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getState().id().method_12832());
    }

    @LuaFunction
    public final int getFuel() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getFuel());
    }

    @LuaFunction
    public final int getStability() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getStability());
    }

    @LuaFunction
    public final boolean boot() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.suggestStateTransition((FlightState)new BootingUpState());
        });
    }

    @LuaFunction
    public final boolean shutdown() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.suggestStateTransition((FlightState)new DisabledState());
        });
    }

    @LuaFunction
    public final boolean isDestinationLocked() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getControls().isDestinationLocked());
    }

    @LuaFunction
    public final boolean setDestinationLocked(IArguments arguments) throws LuaException {
        boolean bool = arguments.getBoolean(0);
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.getControls().setDestinationLocked(bool, false);
        });
    }

    @LuaFunction
    public final boolean areConduitsUnlocked() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getControls().areEnergyConduitsUnlocked());
    }

    @LuaFunction
    public final boolean setConduitsUnlocked(IArguments arguments) throws LuaException {
        boolean bool = arguments.getBoolean(0);
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.getControls().setEnergyConduits(bool);
        });
    }

    @LuaFunction
    public final boolean handbrake(IArguments arguments) throws LuaException {
        boolean bool = arguments.getBoolean(0);
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.getControls().handbrake(bool);
        });
    }

    @LuaFunction
    public final int getCoordinateScale() throws LuaException {
        return this.mainThread(() -> this.getTardisWithException().getControls().getScaleState());
    }

    @LuaFunction
    public final boolean setCoordinateScale(IArguments arguments) throws LuaException {
        int power = arguments.getInt(0);
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            if (power < 0 || power > 3) {
                throw new LuaException("Invalid coordinate scale, range of 0 to 3 is allowed");
            }
            return tardis.getControls().updateCoordinateScale((int)Math.pow(10.0, power));
        });
    }

    @LuaFunction
    public final boolean refuel(IArguments arguments) throws LuaException {
        boolean bool = arguments.getBoolean(0);
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.getControls().refuelToggle(bool);
        });
    }

    @LuaFunction
    public final boolean nudgeDestination(IArguments arguments) throws LuaException {
        class_2350 direction = class_2350.method_10168((String)arguments.getString(0));
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            if (direction == null) {
                throw new LuaException("Invalid direction");
            }
            return tardis.getControls().nudgeDestination(direction);
        });
    }

    @LuaFunction
    public final Integer[] getCurrentPos() throws LuaException {
        return this.mainThread(() -> {
            TardisLocation tardisLocation = (TardisLocation)this.getTardisWithException().getCurrentLocation().left().orElseThrow(() -> new LuaException("Current position of TARDIS is unknown"));
            return new Integer[]{tardisLocation.pos().method_10263(), tardisLocation.pos().method_10264(), tardisLocation.pos().method_10260()};
        });
    }

    @LuaFunction
    public final String getCurrentFacing() throws LuaException {
        return this.mainThread(() -> {
            TardisLocation tardisLocation = (TardisLocation)this.getTardisWithException().getCurrentLocation().left().orElseThrow(() -> new LuaException("Current position of TARDIS is unknown"));
            return tardisLocation.facing().method_15434();
        });
    }

    @LuaFunction
    public final String getCurrentWorld() throws LuaException {
        return this.mainThread(() -> {
            class_5321 world = (class_5321)this.getTardisWithException().getCurrentLocation().map(TardisLocation::worldKey, PartialTardisLocation::worldKey);
            return Utils.worldRegistryToString((class_5321<class_1937>)world);
        });
    }

    @LuaFunction
    public final Integer[] getDestinationPos() throws LuaException {
        return this.mainThread(() -> {
            TardisLocation tardisLocation = (TardisLocation)this.getTardisWithException().getDestination().orElseThrow(() -> new LuaException("Destination of TARDIS is unknown"));
            return new Integer[]{tardisLocation.pos().method_10263(), tardisLocation.pos().method_10264(), tardisLocation.pos().method_10260()};
        });
    }

    @LuaFunction
    public final String getDestinationFacing() throws LuaException {
        return this.mainThread(() -> {
            TardisLocation tardisLocation = (TardisLocation)this.getTardisWithException().getDestination().orElseThrow(() -> new LuaException("Destination of TARDIS is unknown"));
            return tardisLocation.facing().method_15434();
        });
    }

    @LuaFunction
    public final String getDestinationWorld() throws LuaException {
        return this.mainThread(() -> {
            TardisLocation tardisLocation = (TardisLocation)this.getTardisWithException().getDestination().orElseThrow(() -> new LuaException("Destination of TARDIS is unknown"));
            return Utils.worldRegistryToString((class_5321<class_1937>)tardisLocation.worldKey());
        });
    }

    private List<class_5321<class_1937>> availableWorldRegistryKeys(Tardis tardis) {
        Object t;
        Optional dimensions = tardis.getControls().getScreenApp(ScreenAppTypes.DIMENSIONS);
        if (dimensions.isEmpty() || !((t = dimensions.get()) instanceof DimensionsApp)) {
            return List.of((class_5321)tardis.getCurrentLocation().map(TardisLocation::worldKey, PartialTardisLocation::worldKey));
        }
        DimensionsApp dimensionsApp = (DimensionsApp)t;
        return dimensionsApp.accessibleDimensions;
    }

    @LuaFunction
    public final String[] getAvailableWorlds() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return (String[])this.availableWorldRegistryKeys(tardis).stream().map(Utils::worldRegistryToString).toArray(String[]::new);
        });
    }

    @LuaFunction
    public final boolean setDestinationWorld(IArguments arguments) throws LuaException {
        Optional<class_5321<class_1937>> possibleTarget = Utils.stringToWorldRegistry(arguments.getString(0));
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            if (possibleTarget.isEmpty()) {
                throw new LuaException("Invalid destination world");
            }
            class_5321 target = (class_5321)possibleTarget.get();
            List<class_5321<class_1937>> availableWorlds = this.availableWorldRegistryKeys(tardis);
            if (!availableWorlds.contains(target)) {
                throw new LuaException("Destination world is not available");
            }
            return tardis.getControls().moveDestinationToDimension(target);
        });
    }

    @LuaFunction
    public final boolean setDestinationFacing(IArguments arguments) throws LuaException {
        class_2350 direction = class_2350.method_10168((String)arguments.getString(0));
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            if (direction == null || direction == class_2350.field_11033 || direction == class_2350.field_11036) {
                throw new LuaException("Invalid destination facing");
            }
            return tardis.getControls().rotateDestination(direction);
        });
    }

    @LuaFunction
    public final boolean setDestinationPos(IArguments arguments) throws LuaException {
        class_2338 targetPos = new class_2338(arguments.getInt(0), arguments.getInt(1), arguments.getInt(2));
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            TardisLocation targetLocation = tardis.getDestination().map(tardisLocation -> tardisLocation.with(targetPos)).orElseGet(() -> (TardisLocation)tardis.getCurrentLocation().map(tardisLocation -> tardisLocation.with(targetPos), partialTardisLocation -> new TardisLocation(partialTardisLocation.worldKey(), targetPos, class_2350.field_11043)));
            class_3218 targetWorld = targetLocation.getWorld(tardis.getServer());
            if (!targetWorld.method_24794(targetLocation.pos())) {
                throw new LuaException("Target location is not in build limit");
            }
            while (!tardis.canSnapDestinationTo(targetLocation)) {
                if (targetWorld.method_24794((targetLocation = targetLocation.with(targetLocation.pos().method_10093(class_2350.field_11033))).pos())) continue;
                throw new LuaException("Can't find a landing spot at provided target location");
            }
            TardisLocation finalTargetLocation = targetLocation;
            return tardis.setDestination(finalTargetLocation, false);
        });
    }

    @LuaFunction
    public final boolean resetDestination() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            return tardis.getControls().resetDestination();
        });
    }

    @LuaFunction
    public List<List<Integer>> getErrorOffsets() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            Optional flyingState = tardis.getState(FlyingState.class);
            if (flyingState.isEmpty()) {
                throw new LuaException("TARDIS is not in flying state");
            }
            FlyingState state = (FlyingState)flyingState.get();
            ArrayList<List<Integer>> offsets = new ArrayList<List<Integer>>();
            for (int i = 0; i < state.offsets.length; i += 2) {
                offsets.add(List.of(Integer.valueOf(state.offsets[i]), Integer.valueOf(state.offsets[i + 1])));
            }
            return offsets;
        });
    }

    @LuaFunction
    public int getTotalDriftingPhases() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            Optional driftingState = tardis.getState(DriftingState.class);
            if (driftingState.isEmpty()) {
                throw new LuaException("TARDIS is not in flying state");
            }
            DriftingState state = (DriftingState)driftingState.get();
            return state.phaseCount;
        });
    }

    @LuaFunction
    public int getDriftingPhasesComplete() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            Optional driftingState = tardis.getState(DriftingState.class);
            if (driftingState.isEmpty()) {
                throw new LuaException("TARDIS is not in flying state");
            }
            DriftingState state = (DriftingState)driftingState.get();
            return state.phasesComplete;
        });
    }

    @LuaFunction
    public boolean isDriftingPhaseReady() throws LuaException {
        return this.mainThread(() -> {
            Tardis tardis = this.getTardisWithException();
            Optional driftingState = tardis.getState(DriftingState.class);
            if (driftingState.isEmpty()) {
                throw new LuaException("TARDIS is not in flying state");
            }
            DriftingState state = (DriftingState)driftingState.get();
            return state.phaseTicks >= state.phaseLength;
        });
    }

    public String getType() {
        return "minitardis_bridge";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @FunctionalInterface
    public static interface LuaSupplier<T> {
        public T get() throws LuaException;
    }
}

