/*
 * Decompiled with CFR 0.152.
 */
package net.medecoole.medes_decor.datagen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.medecoole.medes_decor.MedesDecor;
import net.medecoole.medes_decor.block.RotatableWalkwayBlock;
import net.medecoole.medes_decor.block.WalkwayBlock;
import net.medecoole.medes_decor.registry.ModBlocks;
import net.medecoole.medes_decor.registry.ModItems;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_7923;

public class ModModelProvider
extends FabricModelProvider {
    public static List<Pair<class_2746, Function<class_2960, class_4935>>> DIRECTION_VARIANTS = List.of(Pair.of((Object)class_2741.field_12489, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model)), Pair.of((Object)class_2741.field_12487, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)), Pair.of((Object)class_2741.field_12540, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)false)), Pair.of((Object)class_2741.field_12527, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)), Pair.of((Object)class_2741.field_12519, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)), Pair.of((Object)class_2741.field_12546, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)));

    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        for (class_2248 block : ModBlocks.PILLARS) {
            ModModelProvider.registerPillar(blockStateModelGenerator, block);
        }
        for (class_2248 block : ModBlocks.BEAMS) {
            ModModelProvider.registerBeam(blockStateModelGenerator, block);
        }
        for (class_2248 block : ModBlocks.SHELVES) {
            ModModelProvider.registerShelf(blockStateModelGenerator, block);
        }
        for (class_2248 block : ModBlocks.WALKWAYS) {
            if (block instanceof RotatableWalkwayBlock) {
                ModModelProvider.registerWalkway(blockStateModelGenerator, block);
                continue;
            }
            ModModelProvider.registerNonRotationalWalkway(blockStateModelGenerator, block);
        }
        for (class_2248 block : ModBlocks.RAILINGS) {
            this.registerRailing(blockStateModelGenerator, block);
        }
        class_4910.class_4912 metalBricksPool = blockStateModelGenerator.method_25650(ModBlocks.METAL_BRICKS);
        metalBricksPool.method_25725(ModBlocks.METAL_BRICKS_STAIRS);
        metalBricksPool.method_25724(ModBlocks.METAL_BRICKS_SLAB);
        metalBricksPool.method_25720(ModBlocks.METAL_BRICKS_WALL);
        blockStateModelGenerator.method_25641(ModBlocks.POLISHED_METAL);
        blockStateModelGenerator.method_31063(ModBlocks.LARGE_METAL_PILLAR, MedesDecor.id("block/large_metal_pillar"));
        blockStateModelGenerator.method_25706(ModBlocks.GOLDEN_LANTERN);
        blockStateModelGenerator.method_25706(ModBlocks.GOLDEN_SOUL_LANTERN);
        blockStateModelGenerator.method_31063(ModBlocks.GOLDEN_CHAIN, class_4941.method_25842((class_2248)ModBlocks.GOLDEN_CHAIN));
        blockStateModelGenerator.method_25681(ModBlocks.LANTERN_BLOCK);
        blockStateModelGenerator.method_25681(ModBlocks.SOUL_LANTERN_BLOCK);
        blockStateModelGenerator.method_25537(ModBlocks.GOLDEN_CHAIN.method_8389());
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(ModItems.METAL_SCRAP, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.IRON_SCRAP, class_4943.field_22938);
        itemModelGenerator.method_25733(ModBlocks.METAL_BRAZIER.method_8389(), class_4943.field_22938);
        itemModelGenerator.method_25733(ModBlocks.METAL_SOUL_BRAZIER.method_8389(), class_4943.field_22938);
    }

    public static void registerBeam(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.method_31063(block, modelId);
        blockStateModelGenerator.method_25623(block, modelId);
    }

    public static void registerPillar(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.method_25681(block);
        blockStateModelGenerator.method_25623(block, modelId);
    }

    public static void registerShelf(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.method_25708(block);
        blockStateModelGenerator.method_25623(block, modelId);
    }

    public static void registerWalkway(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824()).method_25775(class_4910.method_25599()).method_25775(class_4910.method_25565((class_2746)WalkwayBlock.IS_TOP, (class_2960)modelId, (class_2960)modelId.method_48331("_bottom"))));
        blockStateModelGenerator.method_25623(block, modelId);
    }

    public static void registerNonRotationalWalkway(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824()).method_25775(class_4910.method_25565((class_2746)WalkwayBlock.IS_TOP, (class_2960)modelId, (class_2960)modelId.method_48331("_bottom"))));
        blockStateModelGenerator.method_25623(block, modelId);
    }

    public final void registerRailing(class_4910 blockStateModelGenerator, class_2248 block) {
        class_2960 modelId = MedesDecor.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
        blockStateModelGenerator.method_25623(block, modelId);
        class_2960 identifier = class_4941.method_25842((class_2248)block);
        class_4922 multipartBlockStateSupplier = class_4922.method_25758((class_2248)block);
        class_4918.class_4921 propertyCondition = (class_4918.class_4921)class_156.method_654((Object)class_4918.method_25744(), propertyConditionx -> DIRECTION_VARIANTS.stream().map(Pair::getFirst).forEach(property -> {
            if (block.method_9564().method_28498((class_2769)property)) {
                propertyConditionx.method_25751((class_2769)property, (Comparable)Boolean.valueOf(false));
            }
        }));
        for (Pair<class_2746, Function<class_2960, class_4935>> pair : DIRECTION_VARIANTS) {
            class_2746 booleanProperty = (class_2746)pair.getFirst();
            Function function = (Function)pair.getSecond();
            if (!block.method_9564().method_28498((class_2769)booleanProperty)) continue;
            multipartBlockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true)), (class_4935)function.apply(identifier));
            multipartBlockStateSupplier.method_25760((class_4918)propertyCondition, (class_4935)function.apply(identifier));
        }
        blockStateModelGenerator.field_22830.accept(multipartBlockStateSupplier);
    }
}

