/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public abstract class AbstractVRHandTracker {
    public AbstractVRHandTracker() {
        ServerTrackerInit.vrPlayerTrackers.add(this);
    }

    protected abstract boolean shouldRunForHand(class_1657 var1, class_1268 var2, class_1799 var3, IVRPlayer var4, LastTickData var5);

    protected abstract void runForHand(class_1657 var1, class_1268 var2, class_1799 var3, IVRPlayer var4, LastTickData var5);

    public abstract boolean isEnabledInConfig(ActiveConfig var1);

    public void preTick(class_1657 player) {
    }

    public void tick(class_1657 player, IVRPlayer currentVRData, LastTickData lastVRData) {
        for (class_1268 hand : class_1268.values()) {
            if (!this.shouldRunForHand(player, hand, player.method_5998(hand), currentVRData, lastVRData)) continue;
            this.runForHand(player, hand, player.method_5998(hand), currentVRData, lastVRData);
        }
    }

    protected class_2338 getBlockPosAtHand(IVRPlayer vrPlayer, class_1268 hand) {
        IVRData data = vrPlayer.getController(hand.ordinal());
        return class_2338.method_49638((class_2374)data.position());
    }

    protected class_2680 getBlockStateAtHand(class_1657 player, IVRPlayer vrPlayer, class_1268 hand) {
        return player.method_37908().method_8320(this.getBlockPosAtHand(vrPlayer, hand));
    }

    protected class_2248 getBlockAtHand(class_1657 player, IVRPlayer vrPlayer, class_1268 hand) {
        return this.getBlockStateAtHand(player, vrPlayer, hand).method_26204();
    }

    protected boolean movingInDirectionWithThreshold(class_2350 direction, class_243 handVelocity, double threshold) {
        class_2382 blockFacing = direction.method_10163();
        if (this.signsMatch(blockFacing.method_10263(), handVelocity.field_1352) && blockFacing.method_10263() != 0) {
            return Math.abs(handVelocity.field_1352) >= threshold;
        }
        if (this.signsMatch(blockFacing.method_10264(), handVelocity.field_1351) && blockFacing.method_10264() != 0) {
            return Math.abs(handVelocity.field_1351) >= threshold;
        }
        if (this.signsMatch(blockFacing.method_10260(), handVelocity.field_1350) && blockFacing.method_10260() != 0) {
            return Math.abs(handVelocity.field_1350) >= threshold;
        }
        return false;
    }

    protected boolean signsMatch(double a, double b) {
        return a < 0.0 && b < 0.0 || a >= 0.0 && b >= 0.0;
    }
}

