/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.swap;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.mixin.AnvilMenuMixin;
import com.hammy275.immersivemc.server.api_impl.SwapResultImpl;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.storage.world.impl.ETableWorldStorage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1714;
import net.minecraft.class_1718;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2595;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4862;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class Swap {
    public static SwapResult swapItems(class_1799 handStack, class_1799 immersiveStack, ItemSwapAmount swapAmount, int forcedMaxImmersiveStackSize, class_1657 player, @Nullable Consumer<Integer> itemCountIncrementer, @Nullable Consumer<Void> itemCountClearer) {
        class_1799 leftovers;
        class_1799 toHand;
        class_1799 toImmersive;
        boolean immersiveStackAtMax;
        int immersiveMaxStackSize = forcedMaxImmersiveStackSize == -1 ? handStack.method_7914() : forcedMaxImmersiveStackSize;
        int amountToPlace = Math.min(swapAmount.getNumItemsToSwap(), immersiveMaxStackSize);
        boolean handAndImmersiveStackMatch = Util.stacksEqualBesidesCount(handStack, immersiveStack);
        boolean bl = immersiveStackAtMax = immersiveStack.method_7947() == immersiveMaxStackSize;
        if (handAndImmersiveStackMatch && !handStack.method_7960() && !immersiveStackAtMax) {
            class_1799 handStackToPlace = handStack.method_7972();
            handStackToPlace.method_7939(amountToPlace);
            int oldImmersiveCount = immersiveStack.method_7947();
            Util.ItemStackMergeResult mergeResult = Util.mergeStacks(immersiveStack, handStackToPlace, false);
            toImmersive = immersiveStack;
            toHand = handStack.method_7972();
            toHand.method_7934(amountToPlace);
            toHand.method_7933(mergeResult.mergedFrom.method_7947());
            leftovers = class_1799.field_8037;
            int itemsMoved = immersiveStack.method_7947() - oldImmersiveCount;
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(itemsMoved);
            }
        } else if (handStack.method_7960()) {
            boolean stackToInventory = Util.hasItemInInventoryWithStackSpace(player, immersiveStack);
            toHand = stackToInventory ? class_1799.field_8037 : immersiveStack.method_7972();
            toImmersive = class_1799.field_8037;
            class_1799 class_17992 = leftovers = stackToInventory ? immersiveStack.method_7972() : class_1799.field_8037;
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else if (immersiveStackAtMax && handAndImmersiveStackMatch) {
            toHand = immersiveStack.method_7972();
            toImmersive = class_1799.field_8037;
            leftovers = handStack.method_7972();
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else {
            toHand = handStack.method_7972();
            toHand.method_7934(amountToPlace);
            toImmersive = handStack.method_7972();
            toImmersive.method_7939(amountToPlace);
            leftovers = immersiveStack.method_7972();
            if (toHand.method_7960() && !Util.hasItemInInventoryWithStackSpace(player, leftovers)) {
                toHand = leftovers;
                leftovers = class_1799.field_8037;
            }
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(amountToPlace);
            }
        }
        return new SwapResultImpl(toHand, toImmersive, leftovers);
    }

    public static boolean doEnchanting(int slot, class_2338 pos, class_3222 player, class_1268 hand) {
        if (slot < 1 || slot > 3) {
            return false;
        }
        ETableWorldStorage storage = (ETableWorldStorage)WorldStoragesImpl.getOrCreateS(pos, player.method_51469());
        class_1799 toEnchantItem = storage.getItem(0).method_7972();
        if (toEnchantItem.method_7960()) {
            return false;
        }
        int lapisInInventory = 0;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (player.method_31548().method_5438(i).method_7909() != class_1802.field_8759) continue;
            lapisInInventory += player.method_31548().method_5438(i).method_7947();
        }
        if (lapisInInventory < slot && !player.method_31549().field_7477) {
            return false;
        }
        if (player.field_7520 < slot && !player.method_31549().field_7477) {
            return false;
        }
        boolean doApoth = Apoth.apothImpl.enchantModuleEnabled();
        boolean takeLapis = false;
        if (doApoth) {
            ETableStorage.SlotData[] stats = Apoth.apothImpl.getEnchData((class_1657)player, pos, toEnchantItem);
            if (player.field_7520 < stats[slot - 1].xpLevel() && !player.method_31549().field_7477) {
                return false;
            }
            takeLapis = true;
            class_1799 out = Apoth.apothImpl.doEnchant((class_1657)player, pos, slot - 1, toEnchantItem);
            if (out == null) {
                out = toEnchantItem;
            }
            Util.giveStackHandFirst((class_1657)player, hand, out);
            storage.setItem(0, class_1799.field_8037);
        } else {
            class_1718 container = new class_1718(-1, player.method_31548(), class_3914.method_17392((class_1937)player.method_37908(), (class_2338)pos));
            container.method_7619(1, 0, new class_1799((class_1935)class_1802.field_8759, 64));
            container.method_7619(0, 0, toEnchantItem);
            if (container.method_7604((class_1657)player, slot - 1)) {
                takeLapis = true;
                Util.giveStackHandFirst((class_1657)player, hand, container.method_7611(0).method_7677());
                storage.setItem(0, class_1799.field_8037);
            }
        }
        if (takeLapis) {
            int lapisToTake = slot;
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                if (player.method_31548().method_5438(i).method_7909() == class_1802.field_8759) {
                    class_1799 stack = player.method_31548().method_5438(i);
                    while (!stack.method_7960() && lapisToTake > 0) {
                        stack.method_7934(1);
                        --lapisToTake;
                    }
                }
                if (lapisToTake == 0) break;
            }
        }
        return takeLapis;
    }

    public static void handleBackpackCraftingSwap(int slot, class_1268 hand, List<class_1799> items, class_3222 player, ItemSwapAmount amount) {
        class_1799[] itemArray = new class_1799[5];
        for (int i = 0; i <= 4; ++i) {
            itemArray[i] = items.get(i);
        }
        if (slot < 4) {
            class_1799 playerItem = player.method_5998(hand);
            class_1799 tableItem = itemArray[slot];
            SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, tableItem, amount, (class_1657)player);
            itemArray[slot] = result.immersiveStack();
            result.giveToPlayer((class_1657)player, hand);
            itemArray[4] = Swap.getRecipeOutput(player, itemArray);
        } else if ((itemArray = Swap.handleDoCraft(player, itemArray, null, amount)) == null) {
            return;
        }
        for (int i = 0; i <= 4; ++i) {
            items.set(i, itemArray[i]);
        }
        ImmersiveMCPlayerStorages.getPlayerStorage((class_1657)player).method_80();
    }

    public static boolean handleAnvilCraft(AnvilStorage storage, class_2338 pos, class_3222 player, class_1268 hand) {
        class_1799 mid;
        class_1799 left = storage.getItem(0);
        Pair<class_1799, Integer> resAndCost = Swap.getAnvilOutput(left, mid = storage.getItem(1), player);
        if ((player.field_7520 >= (Integer)resAndCost.getSecond() || player.method_31549().field_7477) && !((class_1799)resAndCost.getFirst()).method_7960()) {
            class_1706 container = new class_1706(-1, player.method_31548(), class_3914.method_17392((class_1937)player.method_37908(), (class_2338)pos));
            container.method_7611(2).method_7667((class_1657)player, (class_1799)resAndCost.getFirst());
            if (!player.method_31549().field_7477) {
                player.method_7316(-((Integer)resAndCost.getSecond()).intValue());
            }
            storage.setItem(0, container.method_7611(0).method_7677().method_7972());
            storage.setItem(1, container.method_7611(1).method_7677().method_7972());
            Pair<class_1799, Integer> output = Swap.getAnvilOutput(storage.getItem(0), storage.getItem(1), player);
            storage.setItem(2, (class_1799)output.getFirst());
            storage.xpLevels = (Integer)output.getSecond();
            Util.giveStackHandFirst((class_1657)player, hand, (class_1799)resAndCost.getFirst());
            return true;
        }
        return false;
    }

    public static boolean handleSmithingTableCraft(SmithingTableStorage storage, class_2338 pos, class_3222 player, class_1268 hand) {
        class_1799 right;
        class_1799 mid;
        class_1799 left = storage.getItem(0);
        class_1799 output = Swap.getSmithingTableOutput(left, mid = storage.getItem(1), right = storage.getItem(2), player);
        if (!output.method_7960()) {
            class_4862 container = new class_4862(-1, player.method_31548(), class_3914.method_17392((class_1937)player.method_37908(), (class_2338)pos));
            container.method_7611(3).method_7667((class_1657)player, output);
            storage.shrinkSlot(0, 1);
            storage.shrinkSlot(1, 1);
            storage.shrinkSlot(2, 1);
            storage.setItem(3, class_1799.field_8037);
            Util.giveStackHandFirst((class_1657)player, hand, output);
            return true;
        }
        return false;
    }

    public static class_1799 getRecipeOutput(class_3222 player, class_1799[] stacksIn) {
        int invDim = stacksIn.length >= 9 ? 3 : 2;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(Arrays.asList(stacksIn).subList(0, invDim * invDim));
        class_9694 inv = class_9694.method_59986((int)invDim, (int)invDim, stacks);
        Optional res = player.method_5682().method_3772().method_8132(class_3956.field_17545, (class_9695)inv, player.method_37908());
        if (res.isPresent()) {
            return ((class_3955)((class_8786)res.get()).comp_1933()).method_8116((class_9695)inv, (class_7225.class_7874)player.method_37908().method_30349());
        }
        return class_1799.field_8037;
    }

    @Nullable
    public static class_1799[] handleDoCraft(class_3222 player, class_1799[] stacksIn, class_2338 tablePos, ItemSwapAmount amount) {
        int i;
        int iters;
        class_1799 stackOut;
        boolean isBackpack = stacksIn.length == 5;
        class_1723 menu = isBackpack ? new class_1723(player.method_31548(), false, (class_1657)player) : new class_1714(-1, player.method_31548());
        class_1799 firstOut = stackOut = Swap.getRecipeOutput(player, stacksIn);
        class_1799[] newSlotsState = Arrays.copyOf(stacksIn, stacksIn.length);
        ArrayList<class_1799> stacksToGive = new ArrayList<class_1799>();
        int itersDone = 0;
        int n = iters = amount.getSwapMode() == SwapMode.ALL ? Integer.MAX_VALUE : amount.getNumItemsToSwap();
        while (itersDone++ < iters && class_1799.method_7973((class_1799)firstOut, (class_1799)stackOut) && !stackOut.method_7960() && Swap.itemStackArraysMatchBesidesCount(stacksIn, newSlotsState, isBackpack ? 4 : 9)) {
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                menu.method_7619(i + 1, 0, newSlotsState[i].method_7972());
            }
            menu.method_7611(0).method_7673(stackOut);
            menu.method_7611(0).method_7667((class_1657)player, stackOut);
            stackOut.method_7982(player.method_37908(), (class_1657)player, stackOut.method_7947());
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                newSlotsState[i] = menu.method_7611(i + 1).method_7677();
            }
            stacksToGive.add(stackOut);
            newSlotsState[newSlotsState.length - 1] = stackOut = Swap.getRecipeOutput(player, newSlotsState);
        }
        if (isBackpack) {
            menu.method_7619(0, 0, class_1799.field_8037);
            for (i = 1; i < 5; ++i) {
                menu.method_7619(i, 0, class_1799.field_8037);
            }
        }
        if (stacksToGive.isEmpty()) {
            return null;
        }
        boolean playedSound = false;
        for (class_1799 toGive : stacksToGive) {
            class_1799 handStack = player.method_5998(class_1268.field_5808);
            if (!handStack.method_7960() && Util.stacksEqualBesidesCount(toGive, handStack)) {
                Util.ItemStackMergeResult itemRes = Util.mergeStacks(handStack, toGive, true);
                player.method_6122(class_1268.field_5808, itemRes.mergedInto);
                toGive = itemRes.mergedFrom;
            } else if (handStack.method_7960() && !Util.hasItemInInventoryWithStackSpace((class_1657)player, toGive)) {
                player.method_6122(class_1268.field_5808, toGive);
                toGive = class_1799.field_8037;
            }
            if (!toGive.method_7960()) {
                class_2338 posBlock = tablePos != null ? tablePos.method_10084() : player.method_24515();
                class_243 pos = class_243.method_24953((class_2382)posBlock);
                class_1542 entOut = new class_1542(player.method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, toGive);
                entOut.method_18800(0.0, 0.0, 0.0);
                player.method_37908().method_8649((class_1297)entOut);
                continue;
            }
            if (playedSound) continue;
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, isBackpack ? class_3419.field_15248 : class_3419.field_15245, 0.2f, ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat() * 1.4f + 2.0f);
            playedSound = true;
        }
        return newSlotsState;
    }

    public static void handleInventorySwap(class_1657 player, int slot, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand).method_7972();
        class_1799 invStack = player.method_31548().method_5438(slot).method_7972();
        if (handStack.method_7960() || invStack.method_7960() || !Util.stacksEqualBesidesCount(handStack, invStack)) {
            player.method_6122(hand, invStack);
            player.method_31548().method_5447(slot, handStack);
        } else {
            Util.ItemStackMergeResult res = Util.mergeStacks(invStack, handStack, false);
            player.method_6122(hand, res.mergedFrom);
            player.method_31548().method_5447(slot, res.mergedInto);
        }
    }

    public static void handleChest(class_2595 chestIn, class_3222 player, class_1268 hand, int slot) {
        class_1263 chest;
        class_2595 class_25952 = chestIn = slot > 26 ? Util.getOtherChest(chestIn) : chestIn;
        if (chestIn == null) {
            return;
        }
        class_1263 lootrChest = Lootr.lootrImpl.getContainer(player, chestIn.method_11016());
        Object object = chest = lootrChest != null ? lootrChest : chestIn;
        if (chest != null) {
            class_1799 chestItem = chest.method_5438(slot %= 27).method_7972();
            class_1799 playerItem = player.method_5998(hand);
            if (playerItem.method_7960() || chestItem.method_7960() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
                player.method_6122(hand, chestItem);
                chest.method_5447(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
                player.method_6122(hand, result.mergedFrom);
                chest.method_5447(slot, result.mergedInto);
            }
            chest.method_5431();
        }
    }

    public static void handleEnderChest(class_1657 player, class_1268 hand, int slot) {
        class_1799 chestItem = player.method_7274().method_5438(slot).method_7972();
        class_1799 playerItem = player.method_5998(hand);
        if (playerItem.method_7960() || chestItem.method_7960() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
            player.method_6122(hand, chestItem);
            player.method_7274().method_5447(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
            player.method_6122(hand, result.mergedFrom);
            player.method_7274().method_5447(slot, result.mergedInto);
        }
    }

    public static Pair<class_1799, Integer> getAnvilOutput(class_1799 left, class_1799 mid, class_3222 player) {
        class_1706 container = new class_1706(-1, player.method_31548());
        container.method_7619(0, 0, left);
        container.method_7619(1, 0, mid);
        container.method_24928();
        class_1799 res = container.method_7611(2).method_7677();
        int level = ((AnvilMenuMixin)container).immersiveMC$getCost().method_17407();
        return new Pair((Object)res, (Object)level);
    }

    public static class_1799 getSmithingTableOutput(class_1799 left, class_1799 mid, class_1799 right, class_3222 player) {
        class_4862 container = new class_4862(-1, player.method_31548());
        container.method_7619(0, 0, left);
        container.method_7619(1, 0, mid);
        container.method_7619(2, 0, right);
        container.method_24928();
        class_1799 res = container.method_7611(3).method_7677();
        return res;
    }

    public static boolean itemStackArraysMatchBesidesCount(class_1799[] a, class_1799[] b, int numElements) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < numElements; ++i) {
            class_1799 as = a[i];
            class_1799 bs = b[i];
            if (as == bs || as != null && bs != null && Util.stacksEqualBesidesCount(as, bs)) continue;
            return false;
        }
        return true;
    }
}

